% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.survHE.R
\name{plot.survHE}
\alias{plot.survHE}
\title{Plot survival curves for the models fitted using \code{fit.models}}
\usage{
\method{plot}{survHE}(...)
}
\arguments{
\item{...}{Must include at least one result object saved as
the call to the \code{fit.models} function. Nay include other
optional parameters. These include whether the KM curve should be
added \code{add.km} and whether the user specifies a profile of covariates
(in the list \code{newdata}). Other possibilities are additional
(mainly graphical) options. These are:
\itemize{
\item \code{xlab} = a string with the label for the x-axis (default = "time")
\item \code{ylab} = a string with the label for the y-axis (default = "Survival")
\item \code{lab.profile} = a (vector of) string(s) indicating the labels associated with the strata defining the different
survival curves to plot. Default to the value used by the Kaplan Meier
estimate given in \code{fit.models}.
\item \code{newdata} = a list (of lists) providing the values for the relevant covariates If NULL, then will use
the mean values for the covariates if at least one is a continuous variable,
or the combination of the categorical covariates.
\item \code{xlim} = a vector  determining the limits for the x-axis
\item \code{colors} = a vector of characters defining the colours in which to plot the different survival curves
\item \code{what} = a string indicating whether the survival, hazard or
cumulative hazard curve should be plotted. Defaults to 'survival', but the
other two options can be specified as 'hazard' or 'cumhazard'
\item \code{lab.profile} = a vector of characters defining the names of the models fitted
\item \code{add.km} = TRUE (whether to also add the Kaplan Meier estimates of the data)
\item \code{annotate} = FALSE (whether to also add text to highlight the observed vs
extrapolated data)
\item \code{legend.position} = a vector of proportions to place the legend. Default
to 'c(.75,.9)', which means 75\% across the x-axis and 90\% across the y-axis
\item \code{legend.title} = suitable instructions to format the title of the legend;
defaults to 'element_text(size=15,face="bold")' but there may be other
arguments that can be added (using 'ggplot' facilities)
\item \code{legend.text} = suitable instructions to format the text of the legend;
defaults to 'element_text(colour="black", size=14, face="plain")' but there
may be other arguments that can be added (using 'ggplot' facilities)
}}
}
\description{
Plots the results of model fit.
}
\examples{
\dontrun{
data(bc)

mle = fit.models(formula=Surv(recyrs,censrec)~group,data=bc,
    distr="exp",method="mle")
inla = fit.models(formula=Surv(recyrs,censrec)~group,data=bc,
    distr="exp",method="inla")
plot(MLE=mle,INLA=inla)
}

}
\references{
G Baio (2019). survHE: Survival analysis for health economic evaluation
and cost-effectiveness modelling. Journal of Statistical Software (2020). vol 95,
14, 1-47. \url{doi:10.18637/jss.v095.i14}
}
\seealso{
\code{\link{fit.models}}, \code{\link{write.surv}}
}
\author{
Gianluca Baio
}
\keyword{Parametric}
\keyword{models}
\keyword{survival}
