% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelSim.R
\name{plot.modSim}
\alias{plot.modSim}
\title{Survival or hazard curves of simulated data}
\usage{
\method{plot}{modSim}(x, ind, type = "surv", ...)
}
\arguments{
\item{x}{output of modelSim function (must be of type modSim)}

\item{ind}{vector (individuals to show)}

\item{type}{type of plots (survival or hazard curves)}

\item{...}{supplementary parameters}
}
\value{
plot x
}
\description{
Survival or hazard curves of simulated data
}
\examples{
library(survMS)
ind = sample(1:500, 5)
### Example with survival data simulated from AH model
res_paramLN = get_param_ln(var=170000, mu=2325)
listAHSim_n500_p1000 <- modelSim(model = "AH", matDistr = "unif", matParam = c(-1,1), n = 500, 
                                 p = 100, pnonull = 100, betaDistr = 1.5, hazDistr = "log-normal",
                                 hazParams = c(res_paramLN$a*4, res_paramLN$lambda),
                                 Phi = 0, seed = 1, d = 0)
### Two types of plot are available (survival (by default) and hazard curves)
## Survival curves                                
plot(listAHSim_n500_p1000, ind = ind)
## Hazard curves
plot(listAHSim_n500_p1000, ind = ind, type = "hazard")
}
