% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV1_51.r
\name{NR.rho}
\alias{NR.rho}
\title{Outer Newton-Raphson algorithm for smoothing parameters estimation via LCV or LAML optimization}
\usage{
NR.rho(
  build,
  rho.ini,
  data,
  formula,
  max.it.beta = 200,
  max.it.rho = 30,
  beta.ini = NULL,
  detail.rho = FALSE,
  detail.beta = FALSE,
  nb.smooth,
  tol.beta = 1e-04,
  tol.rho = 1e-04,
  step.max = 5,
  method = "LAML"
)
}
\arguments{
\item{build}{list of objects returned by \code{\link{model.cons}}}

\item{rho.ini}{vector of initial log smoothing parameters; if it is NULL, all log lambda are set to -1}

\item{data}{an optional data frame containing the variables in the model}

\item{formula}{formula object specifying the model}

\item{max.it.beta}{maximum number of iterations to reach convergence in the regression parameters; default is 200}

\item{max.it.rho}{maximum number of iterations to reach convergence in the smoothing parameters; default is 30}

\item{beta.ini}{vector of initial regression parameters; default is NULL, in which case the first beta will be \code{log(sum(event)/sum(t1))} and the others will be zero (except if there are "by" variables in which case all betas are set to zero)}

\item{detail.rho}{if TRUE, details concerning the optimization process in the smoothing parameters are displayed; default is FALSE}

\item{detail.beta}{if TRUE, details concerning the optimization process in the regression parameters are displayed; default is FALSE}

\item{nb.smooth}{number of smoothing parameters}

\item{tol.beta}{convergence tolerance for regression parameters; default is \code{1e-04}}

\item{tol.rho}{convergence tolerance for smoothing parameters; default is \code{1e-04}}

\item{step.max}{maximum absolute value possible for any component of the step vector (on the log smoothing parameter scale); default is 5}

\item{method}{LCV or LAML; default is LAML}
}
\value{
object of class survPen (see \code{\link{survPen.fit}} for details)
}
\description{
Applies Newton-Raphson algorithm for smoothing parameters estimation. Two specific modifications aims at guaranteeing
convergence : first the hessian is perturbed whenever it is not positive definite and second, at each step, if LCV or -LAML
is not minimized, the step is halved until it is.
}
\details{
If we note \code{val} the current LCV or LAML value,
\code{val.old} the previous one and \code{grad} the gradient vector of LCV or LAML with respect to the log smoothing parameters, the algorithm goes on
\code{while(abs(val-val.old)>tol.rho|any(abs(grad)>tol.rho))}
}
\examples{

library(survPen)

# standard spline of time with 4 knots

data <- data.frame(time=seq(0,5,length=100),event=1,t0=0)

form <- ~ smf(time,knots=c(0,1,3,5))

t1 <- eval(substitute(time), data)
t0 <- eval(substitute(t0), data)
event <- eval(substitute(event), data)
	
# Setting up the model before fitting
model.c <- model.cons(form,lambda=0,data.spec=data,t1=t1,t1.name="time",
t0=rep(0,100),t0.name="t0",event=event,event.name="event",
expected=0,expected.name=NULL,type="overall",n.legendre=20,
cl="survPen(form,data,t1=time,event=event)",beta.ini=NULL)
 
# Estimating the smoothing parameter and the regression parameters
# we need to apply a reparameterization to model.c before fitting
Newton2 <- NR.rho(repam(model.c)$build,rho.ini=-1,data,form,nb.smooth=1,detail.rho=TRUE)

}
