% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV1_60.r
\name{model.cons}
\alias{model.cons}
\title{Design and penalty matrices for the model}
\usage{
model.cons(
  formula,
  lambda,
  data.spec,
  t1,
  t1.name,
  t0,
  t0.name,
  event,
  event.name,
  expected,
  expected.name,
  type,
  n.legendre,
  cl,
  beta.ini
)
}
\arguments{
\item{formula}{formula object identifying the model}

\item{lambda}{vector of smoothing parameters}

\item{data.spec}{data frame that represents the environment from which the covariate values and knots are to be calculated}

\item{t1}{vector of follow-up times}

\item{t1.name}{name of \code{t1} in \code{data.spec}}

\item{t0}{vector of origin times (usually filled with zeros)}

\item{t0.name}{name of \code{t0} in \code{data.spec}}

\item{event}{vector of censoring indicators}

\item{event.name}{name of event in \code{data.spec}}

\item{expected}{vector of expected hazard}

\item{expected.name}{name of expected in \code{data.spec}}

\item{type}{"net" or "overall"}

\item{n.legendre}{number of nodes for Gauss-Legendre quadrature}

\item{cl}{original \code{survPen} call}

\item{beta.ini}{initial set of regression parameters}
}
\value{
List of objects with the following items:
\item{cl}{original \code{survPen} call}
\item{type}{"net" or "overall"}
\item{n.legendre}{number of nodes for Gauss-Legendre quadrature. If is.pwcst is TRUE, for simplicity of implementation, n.legendre actually corresponds to the number of sub-intervals}
\item{n}{number of individuals}
\item{p}{number of parameters}
\item{X.para}{design matrix associated with fully parametric parameters (unpenalized)}
\item{X.smooth}{design matrix associated with the penalized parameters}
\item{X}{design matrix for the model}
\item{is.pwcst}{TRUE if there is a piecewise constant (excess) hazard specification. In that case the cumulative hazard can be derived without Gauss-Legendre quadrature}
\item{pwcst.breaks}{if is.pwcst is TRUE, vector of breaks defining the sub-intervals on which the hazard is constant. Otherwise NULL.}
\item{pwcst.weights}{if is.pwcst is TRUE, matrix of weights giving the time contribution of each individual on each sub-interval. Otherwise NULL.}
\item{leg}{list of nodes and weights for Gauss-Legendre integration on [-1;1] as returned by \code{\link[statmod]{gauss.quad}}}
\item{X.GL}{list of matrices (\code{length(X.GL)=n.legendre}) for Gauss-Legendre quadrature}
\item{S}{penalty matrix for the model. Sum of the elements of \code{S.list}}
\item{S.scale}{vector of rescaling factors for the penalty matrices}
\item{rank.S}{rank of the penalty matrix}
\item{S.F}{balanced penalty matrix as described in section 3.1.2 of (Wood,2016). Sum of the elements of \code{S.F.list}}
\item{U.F}{Eigen vectors of S.F, useful for the initial reparameterization to separate penalized ad unpenalized subvectors. Allows stable evaluation of the log determinant of S and its derivatives}
\item{S.smf}{List of penalty matrices associated with all "smf" calls}
\item{S.tensor}{List of penalty matrices associated with all "tensor" calls}
\item{S.tint}{List of penalty matrices associated with all "tint" calls}
\item{S.rd}{List of penalty matrices associated with all "rd" calls}
\item{smooth.name.smf}{List of names for the "smf" calls associated with S.smf}
\item{smooth.name.tensor}{List of names for the "tensor" calls associated with S.tensor}
\item{smooth.name.tint}{List of names for the "tint" calls associated with S.tint}
\item{smooth.name.rd}{List of names for the "rd" calls associated with S.rd}
\item{S.pen}{List of all the rescaled penalty matrices redimensioned to df.tot size. Every element of \code{pen} noted \code{pen[[i]]} is made from a penalty matrix returned by
\code{\link{smooth.cons}} and is multiplied by the factor 
S.scale=norm(X,type="I")^2/norm(pen[[i]],type="I")}
\item{S.list}{Equivalent to S.pen but with every element multiplied by its associated smoothing parameter}
\item{S.F.list}{Equivalent to S.pen but with every element divided by its Frobenius norm}
\item{lambda}{vector of smoothing parameters}
\item{df.para}{degrees of freedom associated with fully parametric terms (unpenalized)}
\item{df.smooth}{degrees of freedom associated with penalized terms}
\item{df.tot}{\code{df.para + df.smooth}}
\item{list.smf}{List of all \code{smf.smooth.spec} objects contained in the model}
\item{list.tensor}{List of all \code{tensor.smooth.spec} objects contained in the model}
\item{list.tint}{List of all \code{tint.smooth.spec} objects contained in the model}
\item{nb.smooth}{number of smoothing parameters}
\item{Z.smf}{List of matrices that represents the sum-to-zero constraints to apply for \code{\link{smf}} splines}
\item{Z.tensor}{List of matrices that represents the sum-to-zero constraints to apply for \code{\link{tensor}} splines}
\item{Z.tint}{List of matrices that represents the sum-to-zero constraints to apply for \code{\link{tint}} splines}
\item{beta.ini}{initial set of regression parameters}
}
\description{
Sets up the model before optimization. Builds the design matrix, the penalty matrix and all the design matrices needed for Gauss-Legendre quadrature.
}
\examples{

library(survPen)

# standard spline of time with 4 knots

data <- data.frame(time=seq(0,5,length=100),event=1,t0=0)

form <- ~ smf(time,knots=c(0,1,3,5))

t1 <- eval(substitute(time), data)
t0 <- eval(substitute(t0), data)
event <- eval(substitute(event), data)

# The following code sets up everything we need in order to fit the model
model.c <- model.cons(form,lambda=0,data.spec=data,t1=t1,t1.name="time",
t0=rep(0,100),t0.name="t0",event=event,event.name="event",
expected=NULL,expected.name=NULL,type="overall",n.legendre=20,
cl="survPen(form,data,t1=time,event=event)",beta.ini=NULL)

}
