% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV1_60.r
\name{survPen.fit}
\alias{survPen.fit}
\title{(Excess) hazard model with multidimensional penalized splines for given smoothing parameters}
\usage{
survPen.fit(
  build,
  data,
  formula,
  max.it.beta = 200,
  beta.ini = NULL,
  detail.beta = FALSE,
  method = "LAML",
  tol.beta = 1e-04
)
}
\arguments{
\item{build}{list of objects returned by \code{\link{model.cons}}}

\item{data}{an optional data frame containing the variables in the model}

\item{formula}{formula object specifying the model}

\item{max.it.beta}{maximum number of iterations to reach convergence in the regression parameters; default is 200}

\item{beta.ini}{vector of initial regression parameters; default is NULL, in which case the first beta will be \code{log(sum(event)/sum(t1))} and the others will be zero (except if there are "by" variables or if there is a piecewise constant hazard specification in which cases all betas are set to zero)}

\item{detail.beta}{if TRUE, details concerning the optimization process in the regression parameters are displayed; default is FALSE}

\item{method}{criterion used to select the smoothing parameters. Should be "LAML" or "LCV"; default is "LAML"}

\item{tol.beta}{convergence tolerance for regression parameters; default is \code{1e-04}. See \code{\link{NR.beta}} for details}
}
\value{
Object of class "survPen" (see \code{\link{survPenObject}} for details)
}
\description{
Fits an (excess) hazard model. If penalized splines are present, the smoothing parameters are specified.
}
\examples{

library(survPen)

# standard spline of time with 4 knots

data <- data.frame(time=seq(0,5,length=100),event=1,t0=0)

form <- ~ smf(time,knots=c(0,1,3,5))

t1 <- eval(substitute(time), data)
t0 <- eval(substitute(t0), data)
event <- eval(substitute(event), data)
	
# Setting up the model before fitting
model.c <- model.cons(form,lambda=0,data.spec=data,t1=t1,t1.name="time",
t0=rep(0,100),t0.name="t0",event=event,event.name="event",
expected=NULL,expected.name=NULL,type="overall",n.legendre=20,
cl="survPen(form,data,t1=time,event=event)",beta.ini=NULL)
 
# fitting
mod <- survPen.fit(model.c,data,form)

}
