% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_ensemble.R
\name{survensemble_cv}
\alias{survensemble_cv}
\title{Cross-validates predictive performance for Ensemble 1}
\usage{
survensemble_cv(
  df,
  predict.factors,
  fixed_time = NaN,
  outer_cv = 3,
  inner_cv = 3,
  repeat_cv = 2,
  randomseed = NULL,
  return_models = FALSE,
  useCoxLasso = FALSE,
  srf_tuning = list(),
  oob = TRUE
)
}
\arguments{
\item{df}{data frame with the data, "time" and "event" for survival outcome}

\item{predict.factors}{list of predictor names}

\item{fixed_time}{at which performance metrics are computed}

\item{outer_cv}{k in k-fold CV, default 3}

\item{inner_cv}{kk in the inner look of kk-fold CV, default 3}

\item{repeat_cv}{if NULL, runs once (or 1), otherwise repeats CV}

\item{randomseed}{random seed}

\item{return_models}{TRUE/FALSE, if TRUE returns all CV objects}

\item{useCoxLasso}{TRUE/FALSE, default is FALSE}

\item{srf_tuning}{list of tuning parameters for random forest: 1) NULL for using a default tuning grid, or 2) a list("mtry"=c(...), "nodedepth" = c(...), "nodesize" = c(...))}

\item{oob}{TRUE/FALSE use out-of-bag predictions while tuning instead of cross-validation, TRUE by default}
}
\value{
list of outputs
}
\description{
Cross-validates predictive performance for Ensemble 1
}
\examples{
\donttest{
\dontshow{rfcores_old <- options()$rf.cores; options(rf.cores=1)}
df <- simulate_nonlinear()
ens_cv <- survensemble_cv(df, names(df)[1:4])
summary(ens_cv)
\dontshow{options(rf.cores=rfcores_old)}
}
}
