% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_model_profile_2d.R
\name{plot.model_profile_2d_survival}
\alias{plot.model_profile_2d_survival}
\title{Plot 2-Dimensional Model Profile for Survival Models}
\usage{
\method{plot}{model_profile_2d_survival}(
  x,
  ...,
  variables = NULL,
  times = NULL,
  marginalize_over_time = FALSE,
  facet_ncol = NULL,
  title = "default",
  subtitle = "default",
  colors = NULL
)
}
\arguments{
\item{x}{an object of class \code{model_profile_2d_survival} to be plotted}

\item{...}{additional objects of class \code{model_profile_2d_survival} to be plotted together}

\item{variables}{list of character vectors of length 2, names of pairs of variables to be plotted}

\item{times}{numeric vector, times for which the profile should be plotted, the times must be present in the 'times' field of the explainer. If \code{NULL} (default) then the median survival time (if available) or the median time from the explainer object is used.}

\item{marginalize_over_time}{logical, if \code{TRUE} then the profile is calculated for all times and then averaged over time, if \code{FALSE} (default) then the profile is calculated for each time separately}

\item{facet_ncol}{number of columns for arranging subplots}

\item{title}{character, title of the plot. \code{'default'} automatically generates either "2D partial dependence survival profiles" or "2D accumulated local effects survival profiles" depending on the explanation type.}

\item{subtitle}{character, subtitle of the plot, \code{'default'} automatically generates "created for the XXX model", where XXX is the explainer labels, if \code{marginalize_over_time = FALSE}, time is also added to the subtitle}

\item{colors}{character vector containing the colors to be used for plotting variables (containing either hex codes "#FF69B4", or names "blue")}
}
\value{
A collection of \code{ggplot} objects arranged with the \code{patchwork} package.
}
\description{
This function plots objects of class \code{"model_profile_2d_survival"} created
using the \code{model_profile_2d()} function.
}
\examples{
\donttest{
library(survival)
library(survex)

cph <- coxph(Surv(time, status) ~ ., data = veteran, model = TRUE, x = TRUE, y = TRUE)
cph_exp <- explain(cph)

cph_model_profile_2d <- model_profile_2d(cph_exp,
    variables = list(
        c("age", "celltype"),
        c("age", "karno")
    )
)
head(cph_model_profile_2d$result)
plot(cph_model_profile_2d, variables = list(c("age", "celltype")), times = cph_exp$times[20])

cph_model_profile_2d_ale <- model_profile_2d(cph_exp,
    variables = list(c("age", "karno")),
    type = "accumulated"
)
head(cph_model_profile_2d_ale$result)
plot(cph_model_profile_2d_ale, times = cph_exp$times[c(10, 20)], marginalize_over_time = TRUE)
}

}
