% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust.lm.onesided.R
\name{robust.lm.onesided}
\alias{robust.lm.onesided}
\title{Robust Regression using One-Sided Huber Function}
\usage{
robust.lm.onesided(formula, data, Q, Qname, maxit = 100, stop = F)
}
\arguments{
\item{formula}{The regression formula (e.g. income ~ employment + old.turnover if income is survey variable and employment and old.turnover are auxiliary variables).}

\item{data}{A data frame including the variables in formula, and gregwt (generalized regression estimator weight), and regwt (weight to be used in regression - will be set to 1 if missing).}

\item{Q}{The tuning parameter where large Q corresponds to no outlier treatment, and small Q corresponds to many outliers being flagged.}

\item{Qname}{Gives a variable name on data which contains a separate tuning parameter Q for every observation (either Q or Qname should be specified but not both).}

\item{maxit}{The maximum number of iterations.}

\item{stop}{Set to T to open a browser window (for debugging purposes)}
}
\value{
The final linear model fit (an object of class "lm").
}
\description{
This function performs robust regression using M-estimation
using the one-sided Huber function, with residuals truncated at Q / (data$gregwt-1)
where data$gregwt is the generalized regression weight.
}
\details{
Uses iteratively reweighted least squares.
}
\examples{
robust.lm.onesided(formula=y~x1+x2,data=survdat.example,Q=250)
}
\references{
Clark, R. G. (1995), "Winsorisation methods in sample surveys," Masters thesis, Australian National University, http://hdl.handle.net/10440/1031.

Kokic, P. and Bell, P. (1994), "Optimal winsorizing cutoffs for a stratified finite population estimator," J. Off. Stat., 10, 419-435.
}

