% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cindex.R
\name{cindex}
\alias{cindex}
\title{Compute Concordance of survivalmodel Risk}
\usage{
cindex(risk, truth, ...)
}
\arguments{
\item{risk}{(\code{numeric()}) \cr
Vector of risk predictions from a \code{survivalmodel} model
(so high risk implies low survival time prediction).}

\item{truth}{(\code{numeric()}) \cr
Vector of true survival times, must be same length as \code{risk}.}

\item{...}{(\code{ANY}) \cr
Further parameters passed to \link[survival:concordance]{survival::concordance}.}
}
\description{
A thin wrapper around \link[survival:concordance]{survival::concordance} which essentially
just sets \code{reverse = TRUE}.
}
\examples{
if (!requireNamespace("survival", quietly = TRUE)) {
  set.seed(10)
  data <- simsurvdata(20)
  fit <- deepsurv(data = data[1:10, ])
  p <- predict(fit, type = "risk", newdata = data[11:20, ])
  concordance(risk = p, truth = data[11:20, "time"])
}
}
