% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gompertz_class.R
\name{s_gompertz}
\alias{s_gompertz}
\title{Factory of SURVIVAL objects with Gompertz distributions}
\usage{
s_gompertz(...)
}
\arguments{
\item{...}{Parameters to define the distribution. See the Parameters for details}
}
\value{
a SURVIVAL object of the Gompertz distribution family. See the
documentation of \code{s_factory} for the methods available for SURVIVAL objects
}
\description{
Creates a SURVIVAL object with an Gompertz distribution.
}
\section{Parameters}{


To create an exponential survival object the following
options are available:

\emph{\code{scale}} and \emph{\code{shape}} to specify the canonical parameter of the distribution, or

\emph{\code{surv}}, \emph{\code{t}} and \emph{\code{shape}}  for the proportion surviving (no events) at time t and shape, or

\emph{\code{fail}} and \emph{\code{t}} and \emph{\code{shape}} for the proportion failing (events) at time t and shape.

scale = -log(surv)·shape/(exp(shape·t))

scale = -log(1-fail)·shape/(exp(shape·t))

The parameters should be spell correctly as partial matching is not available
}

\examples{
s_gompertz(scale = 1, shape = 1.5)
s_gompertz(surv = 0.4, t = 2, shape = 1.5)
s_gompertz(fail = 0.6, t = 2, shape = 1.5)
}
