% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dont_ask.R
\name{dont_ask}
\alias{dont_ask}
\alias{dontAsk}
\title{Can we interrupt R to ask something to the user though the GUI?}
\usage{
dont_ask(gui = .GUI)

dontAsk(gui = .GUI)
}
\arguments{
\item{gui}{A \code{gui} object.}
}
\value{
\code{TRUE} if the GUI cannot interrupt R. The function triggering the
dialog box should then not be displayed and it should return the default
value as the result. The function returns \code{TRUE} if R is run in a non
interactive session, or if \code{ask} is set to \code{FALSE} for the GUI, or if it is
not specified (\code{ask} is \code{NULL}) then \code{getOptions("gui.ask")} is used.
}
\description{
Determine if R code execution can be interrupted by the GUI, e.g., using a
modal dialog box. It depends both on R being in \code{interactive()} mode and the
\code{ask} flag of the GUI being set to \code{TRUE}.
}
\details{
\code{dontAsk} and \code{dont_ask} are aliases.
}
\examples{
# What is the current state for the default GUI?
dont_ask()
}
\seealso{
\code{\link[=gui_ask]{gui_ask()}}, \link{gui}
}
\concept{
GUI API implementation
}
\keyword{misc}
