% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_xxx.R
\name{is_help}
\alias{is_help}
\alias{is_win}
\alias{is_rgui}
\alias{is_sdi}
\alias{is_mac}
\alias{is_aqua}
\alias{is_rstudio}
\alias{is_rstudio_desktop}
\alias{is_rstudio_server}
\alias{is_jgr}
\alias{isHelp}
\alias{isWin}
\alias{isRgui}
\alias{isSDI}
\alias{isMac}
\alias{isAqua}
\alias{isJGR}
\title{Check for the existence of an help file, or some context}
\usage{
is_help(topic, package = NULL, lib.loc = NULL)

is_win()

is_rgui()

is_sdi()

is_mac()

is_aqua()

is_rstudio()

is_rstudio_desktop()

is_rstudio_server()

is_jgr()

isHelp(topic, package = NULL, lib.loc = NULL)

isWin()

isRgui()

isSDI()

isMac()

isAqua()

isJGR()
}
\arguments{
\item{topic}{Name or literal character string: the online help topic to
look for.}

\item{package}{A character vector giving the package names to look into for
help or example code, or \code{NULL}. By default, all packages in the search
path are used.}

\item{lib.loc}{A character vector of directory names of \R libraries, or
\code{NULL}. The default value of \code{NULL} corresponds to all libraries currently
known. If the default is used, the loaded packages are searched before the
libraries.}
}
\value{
All these functions return either \code{TRUE} or \code{FALSE} depending on the
tested item, except for \code{is_help()}, which returns a logical vector with two
elements. The first one indicating if there is a help file, and the second
one indicating if there are examples associated with this help file.
}
\description{
For \code{is_help()}, determine if 'topic' has a help file and
example to run. For \code{is_win()} and \code{is_mac()}, determine if the platform is
Windows or MacOS. For \code{is_aqua()}, is the R UI is AQUA, the standard R GUI
under Macintosh? For \code{is_rgui()}, determine if the default Rgui under Windows
is in use, and with \code{is_sdi()} in this case, you can check if it is in SDI
(single-document interface) \emph{versus} MDI (multi-document interface, by
default). \code{is_rstudio()} and \code{is_rstudio_server()} check if R is run under
RStudio (server), and \code{is_jgr()} indicate if the R GUI is JGR.
}
\note{
The code of \code{is_help()} is largely inspired from the first part of
\code{example()}.

Under \strong{Rgui}, to switch fro MDI to SDI more, go to the menu entry
'Edit' -> 'GUI preferences' to change the Rgui mode, or start Rgui with the
'--SDI' argument line parameter. Under another platform than Windows or if it
is not Rgui, then \code{is_sdi()} always returns \code{FALSE}.`
}
\examples{
is_help("help")		# Help and example
is_help("Rtangle")	# Help but no example
is_help("notopic")	# No help or example

is_win()
is_mac()

is_aqua()
is_rgui()
is_sdi()
is_rstudio()
is_rstudio_desktop()
is_rstudio_server()
is_jgr()
}
\seealso{
\code{\link[=example]{example()}}, \code{\link[=help]{help()}}, \code{\link[=capabilities]{capabilities()}}
}
\concept{
help and example, and OS system platform
}
\keyword{utilities}
