% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_methods.R
\name{list_methods}
\alias{list_methods}
\alias{list_types}
\alias{listMethods}
\alias{listTypes}
\title{List all methods associated with a generic function or a class, or all types
associated with a method}
\usage{
list_methods(f = character(), class = NULL, S3 = TRUE, S4 = TRUE,
  mixed = TRUE, filter = getOption("svGUI.methods"))

list_types(method, class = "default", strict = FALSE)

listMethods(f = character(), class = NULL, S3 = TRUE, S4 = TRUE,
  mixed = TRUE, filter = getOption("svGUI.methods"))

listTypes(method, class = "default", strict = FALSE)
}
\arguments{
\item{f}{The name of the generic function (character string), used only when
\code{class = NULL}.}

\item{class}{The name of a class.}

\item{S3}{If \code{TRUE}, list of S3 methods.}

\item{S4}{If \code{TRUE}, list of S4 methods.}

\item{mixed}{If \code{TRUE}, S3 and S4 methods are mixed together in a character
vector, otherwise, S3 and S4 methods are reported separately in a list.}

\item{filter}{A list of methods to consider when listing class methods. Only
classes in this list that are defined for the class are returned. Store the
list of methods you want in the options \code{"svGUI.methods"}. The package
proposes a reasonable starting point on loading if this option is not defined
yet.}

\item{method}{The method name.}

\item{strict}{Do we list only types for the class (\code{TRUE}), or all
possible types, including for inherited objects, and default ones \code{FALSE},
by default)?}
}
\value{
For \code{list_methods()}, if \code{mixed = TRUE}, a list with components:
\itemize{
\item \code{S3} The S3 methods for the generic function or the class, or
\code{character(0)} if none
\item \code{S4} The S4 methods for the generic function or the class, or
\code{character(0)} if none.
}

Otherwise, a character vector with the requested methods.

For \code{list_types()}, a vector with character strings with methods' type names.
}
\description{
List all S3 and/or S4 methods for a generic function or for a
class. List all types for a method; types are variants for a given method
defined in a way it is easy to add other variants dynamically (on the
contrary to a usual \code{type =} or \code{which =} argument, like in \code{\link[=plot.ts]{plot.ts()}} or
\code{\link[=plot.lm]{plot.lm()}}, respectively.
}
\note{
\code{list_types()} is only useful for special generic functions with type
argument like \code{view}, \code{copy} or \code{export}. These functions offer a mechanism
to easily add custom types, and the present function list them. For S3
objects a type is simply a function whose name is : <method>_<type>.<class>.
So, adding new <type>s for <method> is very easy to implement.
}
\examples{
# Generic functions
list_methods("t.test")               # S3
list_methods("show", mixed = FALSE)	# S4
list_methods("ls") # None, not a generic function!

# Classes
# Only the following methods are considered
getOption("gui.methods")
list_methods(class = "data.frame")
list_methods(class = "lm")

# List method types
list_types("view")  # All default view types currently defined
list_types("view", "data.frame")
list_types("view", "data.frame", TRUE) # None, except if you defined custom views!
}
\seealso{
\code{\link[=obj_menu]{obj_menu()}}
}
\concept{
classes, objects and methods
}
\keyword{utilities}
