% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf.R
\name{cf}
\alias{cf}
\title{Counterfactuals for SVAR Models}
\usage{
cf(x, series = 1, transition = 0)
}
\arguments{
\item{x}{SVAR object of class "svars"}

\item{series}{Integer. indicating the series for which the counterfactuals should be calculated.}

\item{transition}{Numeric. Value from [0, 1] indicating how many initial values should be discarded, i.e., 0.1 means that the first 10 per cent observations of the sample are considered as transient.}
}
\value{
A list with class attribute "hd" holding the Counterfactuals as data frame.
}
\description{
Calculation of Counterfactuals for an identified SVAR object 'svars' derived by function id.st( ), id.cvm( ),id.cv( ),id.dc( ) or id.ngml( ).
}
\examples{
\donttest{
v1 <- vars::VAR(USA, lag.max = 10, ic = "AIC" )
x1 <- id.dc(v1)
x2 <- cf(x1, series = 2)
plot(x2)
}

}
\references{
Kilian, L., Luetkepohl, H., 2017. Structural Vector Autoregressive Analysis, Cambridge University Press.
}
\seealso{
\code{\link{id.cvm}}, \code{\link{id.dc}}, \code{\link{id.ngml}}, \code{\link{id.cv}}, \code{\link{id.garch}} or \code{\link{id.st}}
}
