% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinICC.R
\name{BinICC}
\alias{BinICC}
\title{A function for calculating the intracluster correlation coefficient (ICC) for binary outcomes given the cluster level random effects variance}
\usage{
BinICC(link = "identity", meanresponse_start, tau2 = 0)
}
\arguments{
\item{link}{choose link function from link="identity", link="log" and link="logit", with default value of identity link}

\item{meanresponse_start}{the anticipated mean response in the control group at the start of the study}

\item{tau2}{also denoted as sigma_b: variance of the between-cluster random effect, default is 0}
}
\value{
The object returned includes the link function and value for the ICC in this study
}
\description{
This function calculates the ICC (intracluster correlation coeffcient which measures the correlation between individuals in the same cluster) under different link funcitions in a cross-sectional stepped wedge CRT with binary outcomes. This model considers only the fixed time effects and does not include cluster by time interaction random effect.
}
\examples{
BinICC(link="identity",meanresponse_start=0.2,tau2=0.05)

}
