% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContICC.R
\name{ContICC}
\alias{ContICC}
\title{A function for calculating ICCs for continuous outcomes given random effects variances}
\usage{
ContICC(
  type = "cross-sectional",
  sigma2 = 1,
  sigma_b = 0,
  sigma_c = 0,
  sigma_pi = NA
)
}
\arguments{
\item{type}{choose the study type, specify type="cohort" for closed cohort study and type="cross-sectional" for cross-sectional study, default is "cross-sectional"}

\item{sigma2}{marginal variance of the outcom, default is 1}

\item{sigma_b}{variance of the between-cluster random effect, default is 0}

\item{sigma_c}{variance of the cluster-by-time interaction random effect, default is 0}

\item{sigma_pi}{variance of the random effect for repeated measures of one individual, this parameter should not be specified for cross-sectional studies, default is NA}
}
\value{
The object returned includes the study type and values for the ICCs in this study
}
\description{
This function calculates the within-period, between-period, and within-individual correlation parameters for continuous outcomes in a stepped wedge CRT
}
\examples{
ContICC(type="cohort",sigma2=1.5,sigma_b=0.5,sigma_c=0.2,sigma_pi=0.3)
}
