% Generated by roxygen2 (4.0.1): do not edit by hand
\name{pin_age}
\alias{pin_age}
\title{Calculate age of \code{pin} for a given date}
\usage{
pin_age(pin, date = Sys.Date(), timespan = "years")
}
\arguments{
\item{date}{Date at which age is calculated.}

\item{timespan}{Timespan to use to calculate age. The actual timespans are:
\itemize{
  \item \code{years} (Default)
  \item \code{months}
  \item \code{weeks}
  \item \code{days}
}}

\item{pin}{A vector of class \code{pin}. See \link{as.pin}.}
}
\value{
Age as an integer vector.
}
\description{
Calculate the age in full years for a given date.
}
\examples{
# Example with someone born today
today_pin <-
  paste(paste(unlist(strsplit(as.character(Sys.Date()),split = "-")), collapse = ""),
        "0000",sep="")
pin_age(today_pin)

# Examples taken from SKV 704 (see references)
ex_pin <- c("196408233234", "186408833224")
pin_age(ex_pin, date = "2012-01-01")
}
\references{
\href{https://www.skatteverket.se/download/18.1e6d5f87115319ffba380001857/1285595720207/70408.pdf}{SKV 704}
}

