% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airdas_sight.R
\name{airdas_sight}
\alias{airdas_sight}
\alias{airdas_sight.data.frame}
\alias{airdas_sight.airdas_df}
\title{Aerial DAS sightings}
\usage{
airdas_sight(x, ...)

\method{airdas_sight}{data.frame}(x, ...)

\method{airdas_sight}{airdas_df}(x, angle.min = 12, ...)
}
\arguments{
\item{x}{\code{airdas_df} object; output from \code{\link{airdas_process}}, 
or a data frame that can be coerced to a \code{airdas_df} object}

\item{...}{ignored}

\item{angle.min}{numeric; the minimum (absolute value) angle 
for which to consider a sighting a standard sighting. Default is 12}
}
\value{
Data frame with 1) the columns from \code{x}, excluding the 'Data#' columns,
  and 2) columns with sighting information extracted from 'Data#' columns as described below.
  The data frame has one row for each sighting, or one row for each 
  species of each sighting if it is a multi-species (mixed) sighting.
  
  Added sighting information columns:
  \tabular{lll}{
    \emph{Sighting information}       \tab \emph{Column name} \tab \emph{Notes}\cr
    Sighting number                   \tab SightNo\cr
    Observer that made the sighting   \tab Obs\cr
    Angle of declination              \tab Angle    \tab Left is negative\cr
    Sighting by standard observer     \tab ObsStd   \tab Logical; described in Details\cr
    Standard sighting                 \tab SightStd \tab Logical; described in Details\cr
    Mixed species sighting            \tab Mixed    \tab Logical\cr
    Species code                      \tab SpCode   \tab All characters converted to lower case\cr
    Group size of school              \tab GsTotal  \tab Only different from GsSp for mixed species sightings\cr
    Group size of species             \tab GsSp\cr
    Turtle length (feet if numeric)   \tab TurtleSize      \tab \code{NA} for non-"t" events; may be character or numeric\cr
    Turtle travel direction (degrees) \tab TurtleDirection \tab \code{NA} for non-"t" events\cr
    Turtle tail visible?              \tab TurtleTail      \tab \code{NA} for non-"t" events\cr
  }
  
  The TurtleSize will be of class character is there is any 
  CARETTA data in \code{x}, and of class numeric otherwise.
}
\description{
Extract sighting information from aerial DAS data
}
\details{
AirDAS events contain specific information in the 'Data#' columns,
  with the information depending on the event code and file type for that row.
  This function extracts relevant data for sighting events, and returns a
  data frame with dedicated columns for each piece of sighting information. 
  It can handle multiple file types in \code{x}; for instance, 
  \code{x} could be processed PHOCOENA and TURTLE data
  combined using \code{\link[base:cbind]{rbind}}. 
  See \code{\link{airdas_format_pdf}} for more information about the expected
  events and event formats, depending on the file type.
  
  All species codes are converted to lower case using \code{\link[base:chartr]{tolower}}.
   
  Abbreviations used in column names include: Gs = group size, Sp = species, 
  Mixed = mixed species (multi-species) sighting. 
  In addition, note that multi-species group sizes are rounded to 
  the nearest whole number using \code{round(, 0)}
  
  A 'sighting by a standard observer' ('ObsStd') is a sighting 
  made by ObsL, ObsB, or ObsR (not the data recorder or pilot).   
  A 'standard sighting' ('SightStd') is a sighting 
  that was made while on effort, by a standard observer, 
  and with the absolute value of the angle of declination 
  being greater than or equal to \code{angle.min}.   
  Resights (Events 's') are not considered standard events, 
  and thus both 'ObsStd' and 'SightStd' will be \code{NA} for 's' events.
}
\examples{
y <- system.file("airdas_sample.das", package = "swfscAirDAS")
y.proc <- airdas_process(y)

airdas_sight(y.proc)

}
