% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intersectingPoint.R
\name{intersectingPoint}
\alias{intersectingPoint}
\title{Intersecting Point}
\usage{
intersectingPoint(pts, p1 = NULL, p2 = NULL, intercept = NULL, slope = NULL)
}
\arguments{
\item{pts}{two element vector or two column matrix of x and y values of 
points.}

\item{p1, p2}{two element vectors of two points laying on line.}

\item{intercept, slope}{the intercept and slope of the line.}
}
\value{
A matrix containing columns giving the x and y values of the 
  intersecting point on the line, and the distance to each point.
}
\description{
Calculates the perpendicular point and distance to a line 
  for a series of points.
}
\note{
The line can be specified by providing either \code{p1} and \code{p2} 
  or \code{intercept} and \code{slope}. If \code{intercept} and 
  \code{slope} are specified, then \code{p1} and \code{p2} will be ignored.
}
\examples{

pts <- cbind(x = runif(5, 0, 10), y = runif(5, 0, 10))

intersectingPoint(pts, p1 = c(-1, -1), p2 = c(60, 60))

intersectingPoint(pts, intercept = 0, slope = 1)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
