% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_course.R
\name{install_course}
\alias{install_course}
\title{Install a course from The swirl Course Network or install a course from a
local .swc file.}
\usage{
install_course(course_name = NULL, swc_path = NULL, force = FALSE)
}
\arguments{
\item{course_name}{The name of the course you wish to install.}

\item{swc_path}{The path to a local \code{.swc} file. By default this
argument defaults to \code{file.choose()} so the user can select the file using
their mouse.}

\item{force}{Should course installation be forced? The 
default value is \code{FALSE}.}
}
\description{
Version 2.4 of swirl introduces a new, simple, and fast way of installing
courses in the form of \code{.swc} files. This function allows a user to grab
a \code{.swc} file from The swirl Course Network which is maintained by Team
swirl, or the user can use this function to install a local \code{.swc} file.
When using this function please only provide an argument for either
\code{course_name} or \code{swc_path}, never both.
}
\examples{
\dontrun{

# Install the latest version of Team swirl's R Programming course.
install_course("R Programming")

# Install a local .swc file by using your mouse and keyboard to select the
# file.
install_course()

# Install a .swc file from a specific path.
install_course(swc_path = file.path("~", "Downloads", "R_Programming.swc"))

}
}
\seealso{
Other InstallCourses: \code{\link{InstallCourses}},
  \code{\link{install_course_directory}},
  \code{\link{install_course_dropbox}},
  \code{\link{install_course_github}},
  \code{\link{install_course_google_drive}},
  \code{\link{install_course_url}},
  \code{\link{install_course_zip}},
  \code{\link{install_from_swirl}},
  \code{\link{uninstall_all_courses}},
  \code{\link{uninstall_course}}, \code{\link{zip_course}}
}

