% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_to_dfr.R
\name{canton_json_to_dfr}
\alias{canton_json_to_dfr}
\title{Transform a opendata.swiss cantonal results json into a tibble}
\usage{
canton_json_to_dfr(votedate = NULL, geolevel = "municipality",
  dataurl = NULL, index = NULL)
}
\arguments{
\item{votedate}{date of the ballot. Default: most recent ballot available.}

\item{geolevel}{geographical level for which the results should be loaded. options."canton","district" or "municipality"}

\item{dataurl}{list of datasets / metadata for the given dataset and its resources OR url of the dcat dataset on opendata.swiss}

\item{index}{selection by index of the resource (last published = 1).}
}
\value{
a tibble containing the results
}
\description{
\code{canton_json_to_dfr} Tranforms a single results json for a selected cantonal votedate into a tibble.
}
\examples{

# get and transform the json for the most recent vote
results <- canton_json_to_dfr()

# get and transform the json for a single votedate at counting district level
canton_json_to_dfr(votedate="2020-02-09",geolevel = "zh_counting_districts")



}
