% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.mnprobit}
\alias{coef.mnprobit}
\title{Coefficients extraction method for mnprobit.}
\usage{
\method{coef}{mnprobit}(object, ..., alt = NULL, regime = NULL, type = "coef")
}
\arguments{
\item{object}{object of class "mnprobit"}

\item{...}{further arguments (currently ignored)}

\item{alt}{integer representing index of the alternative}

\item{regime}{integer representing regime of the continuous equation}

\item{type}{character representing the type of the output. Possible options
are \code{"coef"}, \code{"coef2"}, \code{"cov1"}, \code{"var"},
\code{"cov2"}, \code{coef_lambda}.
See 'Details' for additional information.}
}
\value{
See 'Details' section.
}
\description{
Extract coefficients and other estimates from mnprobit object.
}
\details{
Consider notations from the 'Details' section of 
\code{\link[switchSelection]{mnprobit}}.

Suppose that \code{type = "coef"}. Then estimates of \eqn{\gamma_{j}} 
coefficients are returned for each \eqn{j\in\{1,...,J\}}. If \code{alt = j} 
then only estimates of \eqn{\gamma_{j}} coefficients are returned.

Suppose that \code{type = "coef2"}. Then estimates of \eqn{\beta_{r}}
coefficients are returned for each \eqn{r\in\{0,...,R - 1\}}. 
If \code{regime = r} then estimates only for the \eqn{r}-th regime are
returned.

Suppose that \code{type = "cov1"}. Then estimate of the covariance matrix of
\eqn{u_{i}} is returned. If \code{alt = c(a, b)} then the function returns
\eqn{(a, b)}-th element of this matrix i.e. an element from 
\code{a}-th row and \code{b}-th column that is an estimate of
\eqn{Cov(u_{ai},u_{bi})}.

Suppose that \code{type = "cov12"}. Then estimates of covariances between
\eqn{u_{i}} and \eqn{\varepsilon_{i}} are returned. 
If \code{alt = j} and \code{regime = r} then the function returns 
an estimate of \eqn{Cov(u_{ji}, \varepsilon_{ri})}.

Suppose that \code{type = "var"} or \code{type = "cov2"}. Then estimates of
the variances of \eqn{\varepsilon_{i}} are returned.
If \code{regime = r} then estimate of \eqn{Var(\varepsilon_{ri})} 
is returned.

Suppose that \code{type = "coef_lambda"}. Then estimates of the coefficients
for \eqn{\hat{\lambda}^{t}_{ji}} are returned i.e. 
estimates of \eqn{\tau_{jt}} for each regime.
If \code{regime = r} then estimates are returned for the \eqn{r}-th regime. 
If in addition \code{alt = j} then only estimates for this \eqn{j}-th 
alternative and \eqn{r}-th regime are returned.
}
