% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.mvoprobit}
\alias{predict.mvoprobit}
\title{Predict method for mvoprobit function}
\usage{
\method{predict}{mvoprobit}(
  object,
  ...,
  newdata = NULL,
  given_ind = numeric(),
  group = NULL,
  group2 = NULL,
  type = ifelse(is.null(group2), "prob", "val"),
  me = NULL,
  eps = NULL,
  control = list(),
  se = FALSE
)
}
\arguments{
\item{object}{object of class "mvoprobit"}

\item{...}{further arguments (currently ignored)}

\item{newdata}{an optional data frame in which to look for variables 
with which to predict. If omitted, the original data frame used.
This data frame should contain values of dependent variables even if
they are not actually needed for prediction 
(simply assign them with 0 values).}

\item{given_ind}{numeric vector of indexes of conditioned components.}

\item{group}{numeric vector which i-th element represents a value of the
i-th dependent variable. If this value equals -1 then this component
will be ignored (useful for estimation of marginal probabilities).}

\item{group2}{numeric vector which i-th element represents a value of the
i-th dependent variable of the continuous equation. 
If this value equals -1 then this component will be ignored.}

\item{type}{string representing a type of prediction. See 'Details' for
more information.}

\item{me}{string representing the name of the variable for which marginal
effect should be estimated. See 'Details' for more information.}

\item{eps}{numeric vector of length 1 or 2 used for calculation of
marginal effects. See 'Details'.}

\item{control}{list of additional arguments. Currently is not intended
for the users.}

\item{se}{logical; if \code{TRUE} then the function also returns standard 
errors and p-values of the two-sided significance test associated with the 
function output. 
Works only if \code{\link[switchSelection]{predict.mvoprobit}} returns
numeric vector or a single column matrix. 
See \code{\link[switchSelection]{delta_method}} for more information.}
}
\value{
This function returns predictions for each row of \code{newdata}
or for each observation in the model if \code{newdata} is \code{NULL}.
Structure of the output depends on the \code{type} argument
(see 'Details' section).
}
\description{
Predicted values based on object of class 'mvoprobit'.
}
\details{
See 'Examples' section of \code{\link[switchSelection]{mvoprobit}}
for examples of this function application.

If \code{type = "prob"} then function returns a joint probability that
dependent variables will have values assigned in \code{group}. To calculate
marginal probabilities set unnecessary \code{group} values to -1. To
estimate conditional probabilities provide indexes of conditioned variables
through \code{given_ind}. For example if \eqn{z_{1}}, \eqn{z_{2}} and 
\eqn{z_{3}} are dependent variables then to calculate 
\eqn{P(z_{1}=2 | z_{3} = 0)} set \code{given_ind = 3} and 
\code{groups = c(2, -1, 0)}. Note that conditioning on covariates 
(regressors) is omitted for notations brevity and this conditioning depends 
on the values in \code{newdata}.

If \code{type = "li"} then function returns a matrix which columns are
linear indexes of corresponding equations.

If \code{type = "sd"} then function returns a matrix which columns are
standard deviations of random errors for corresponding equations. 

If \code{type = "li"} or \code{type = "sd"} and some \code{groups} are equal
to -1 then corresponding components will be omitted from the output matrix.

If \code{type = "val"} then function returns predictions of conditional 
(on \code{group}) expectation of dependent variable in continuous equations
with regimes determined by \code{group2} argument. To predict unconditional 
expectations just set \code{group = NULL}.

If \code{type = "lambda"} then function returns conditional 
(on \code{group}) expectations of random error of continuous equation
in regime \code{group2}.

If \code{type = "val"} or \code{type = "lambda"} then output is a matrix
which \code{i}-th column corresponds to prediction associated with
\code{i}-th continuous equation.

If \code{me} is provided then the function returns marginal effect
of variable \code{me} respect to the statistic determined by \code{type}
argument. 
For example if \code{me = "x1"} and \code{type = "prob"} then function 
returns marginal effect of \code{x1} on the corresponding probability 
i.e. one that would be estimated if \code{me} is \code{NULL}.

If \code{length(eps) = 1} then \code{eps} is an increment in 
numeric differentiation procedure. 
If \code{eps} is \code{NULL} then this increment will be selected 
automatically taking into account scaling of variables. 
If \code{length(eps) = 2} then marginal effects will be estimated as the
difference of predicted value when variable \code{me} equals \code{eps[2]}
and \code{eps[1]} correspondingly. 

For example suppose that 
\code{type = "prob"}, \code{me = "x1"}, \code{given_ind = 3} and
\code{groups = c(2, -1, 0)}. Then if \code{eps} is a \code{NULL} or a 
small number (something like \code{eps = 0.0001}) the following marginal
effect will be estimated (via first difference numeric differentiation):
 \deqn{\frac{\partial P(z_{1}=2 | z_{3} = 0)}{\partial x_{1}}.}
 If \code{eps = c(1, 3)} then the function estimates the following difference
 (useful for estimation of marginal effects of ordered covariates):
 \deqn{P(z_{1}=2 | z_{3} = 0, x_{1} = 3) - 
      P(z_{1}=2 | z_{3} = 0, x_{1} = 1).}
}
