% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.R
\name{vcov.mnprobit}
\alias{vcov.mnprobit}
\title{Calculate Variance-Covariance Matrix for a mnprobit Object.}
\usage{
\method{vcov}{mnprobit}(
  object,
  ...,
  type = object$cov_type,
  regime = NULL,
  n_cores = object$other$n_cores,
  n_sim = object$other$n_sim
)
}
\arguments{
\item{object}{an object of class \code{mnprobit}.}

\item{...}{further arguments (currently ignored).}

\item{type}{character representing the type of the asymptotic covariance 
matrix estimator. If}

\item{regime}{non-negative integer representing the regime of the two-step
procedure for which covariance matrix should be returned.
If \code{estimator = "2step"} and \code{regime = NULL} then covariance
matrix of the first step parameters' estimator will be returned.
Otherwise the function estimates covariance matrix for the second step
parameters associated with corresponding regime.}

\item{n_cores}{positive integer representing the number of CPU cores used for 
parallel computing. If possible it is highly recommend to set it equal to
the number of available physical cores especially when the system of
ordered equations has 2 or 3 equations.
\code{estimator} argument of \code{\link[switchSelection]{mnprobit}} is 
\code{"ml"} then \code{type} may be changed to any value available for input 
argument \code{cov_type} of \code{\link[switchSelection]{mnprobit}}. 
Otherwise \code{type} will coincide with \code{cov_type} output value 
of \code{\link[switchSelection]{mnprobit}}.}

\item{n_sim}{integer representing the number of GHK draws when there are
more then 3 ordered equations. Otherwise alternative (much more efficient) 
algorithms will be used to calculate multivariate normal probabilities.}
}
\value{
Returns numeric matrix which represents estimate of the asymptotic 
covariance matrix of model's parameters.
}
\description{
Return the variance-covariance matrix of the parameters of
mnprobit model.
}
\details{
Argument \code{type} is closely related to the argument 
\code{cov_type} of \code{\link[switchSelection]{mnprobit}} function. 
See 'Details' and 'Usage' sections of 
\code{\link[switchSelection]{mnprobit}} 
for more information on \code{cov_type} argument.
}
