% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.sylly.env.R
\name{set.sylly.env}
\alias{set.sylly.env}
\title{A function to set information on your sylly environment}
\usage{
set.sylly.env(..., validate = TRUE)
}
\arguments{
\item{...}{Named parameters to set in the sylly environment. Valid arguments are:
\describe{
  \item{lang}{ A character string specifying a valid language.}
  \item{hyph.cache.file}{ A character string specifying a path to a file to use for storing already hyphenated data,
      used by \code{\link[sylly:hyphen]{hyphen}}.}
  \item{hyph.max.token.length}{ A single number to set the internal cache size for tokens. The value should be set to the longest token to be hyphenated.}
}
To explicitly unset a value again, set it to an empty character string (e.g.,
      \code{lang=""}).}

\item{validate}{Logical,
      if \code{TRUE} given paths will be checked for actual availablity, and the function will fail if files can't be found.}
}
\value{
Returns an invisible \code{NULL}.
}
\description{
The function \code{set.sylly.env} can be called before any of the hyphenation functions. It preserves some information
on your current session's settings to a hidden environment.
}
\details{
To get the contents of the hidden environment,
      the function \code{\link[sylly:get.sylly.env]{get.sylly.env}}
can be used.
}
\examples{
set.sylly.env(hyph.cache.file=file.path(tempdir(), "cache_file.RData"))
get.sylly.env(hyph.cache.file=TRUE)
}
\seealso{
\code{\link[sylly:get.sylly.env]{get.sylly.env}}
}
\keyword{misc}
