#' Hyphenation and Syllable Counting for Text Analysis.
#'
#' \tabular{ll}{
#' Package: \tab sylly\cr
#' Type: \tab Package\cr
#' Version: \tab 0.1-4\cr
#' Date: \tab 2018-01-06\cr
#' Depends: \tab R (>= 3.0.0)\cr
#' Encoding: \tab UTF-8\cr
#' License: \tab GPL (>= 3)\cr
#' LazyLoad: \tab yes\cr
#' URL: \tab https://reaktanz.de/?c=hacking&s=sylly\cr
#' }
#'
#' Provides the hyphenation algorithm used for 'TeX'/'LaTeX' and similar software, as
#' proposed by Liang (1983, <https://tug.org/docs/liang/>). Mainly contains the function hyphen()
#' to be used for hyphenation/syllable counting of text objects. It was originally developed
#' for and part of the 'koRpus' package, but later released as a separate package so it's
#' lighter to have this particular functionality available for other packages. Support for
#' various languages needs be added on-the-fly or by plugin packages
#' (<https://undocumeantit.github.io/repos>); this package does not include any language specific data. Due to some
#' restrictions on CRAN, the full package sources are only available from the project homepage. To
#' ask for help, report bugs, request features, or discuss the development of the package,
#' please subscribe to the koRpus-dev mailing list (<http://korpusml.reaktanz.de>).
#'
#' @aliases sylly-package
#' @name sylly-package
#' @docType package
#' @title The sylly Package
#' @author Meik Michalke
#' @keywords package
NULL
