## ---- include = FALSE---------------------------------------------------------
#knitr::opts_chunk$set(
#    collapse = TRUE,
#    comment = "#>"
#)

## ----include=FALSE------------------------------------------------------------
library(symengine)

## -----------------------------------------------------------------------------
x <- Symbol("x")
x

## -----------------------------------------------------------------------------
expr <- S("(x + 2*y)^3")
expr

## -----------------------------------------------------------------------------
use_vars(x, y, z, .quiet = TRUE)
expr <- (x + y + z) ^ 2L - 42L
expand(expr)

## -----------------------------------------------------------------------------
expr <- (x + y + z) ^ 2L - 42L
expr <- subs(expr, z, S("a"))
expr <- subs(expr, y, x^2L)
expr

## -----------------------------------------------------------------------------
use_vars(x, y, .quiet = TRUE)
expr <- (x + 2L*sin(y))^3L
D(expr, y)

## -----------------------------------------------------------------------------
a <- Symbol("a")
poly <- x^2L + 2L*a*x + a^2L
solve(poly, x)

## -----------------------------------------------------------------------------
use_vars(x, y, z, .quiet = TRUE)
vec <- c(x, x + y, x + y - z)
vec

## -----------------------------------------------------------------------------
lst <- list(x, x + y, x + y + z)
Vector(lst)

## -----------------------------------------------------------------------------
nms <- paste0("x_", rep(1:2, 3), rep(1:3, 2))
Matrix(nms, nrow = 2)

## -----------------------------------------------------------------------------
vec <- Vector(x, y, z)
rbind(vec, vec^2L-1L)

## -----------------------------------------------------------------------------
expr <- x^y + exp(x)
func <- as.function(expr)
func(x = 1:10, y = 2)

## -----------------------------------------------------------------------------
old_options <- options(symengine.latex = TRUE, symengine.latex.center = TRUE)

## -----------------------------------------------------------------------------
use_vars(x, y, .quiet = TRUE)
sqrt(x + y)

## -----------------------------------------------------------------------------
options(old_options)

