% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_accuracy_by_triage.R
\name{get_accuracy_by_triage}
\alias{get_accuracy_by_triage}
\title{get_accuracy_by_triage}
\usage{
get_accuracy_by_triage(data, correct, triagelevel, apps = NULL)
}
\arguments{
\item{data}{A dataframe}

\item{correct}{A string indicating the column name storing if the symptom checker solved the case (TRUE or FALSE)}

\item{triagelevel}{A string indicating the column name storing the correct triage solutions}

\item{apps}{A string indicating the column name storing the app names (optional)}
}
\value{
A data frame object containing the accuracy on each triage level (of one or multiple symptom checkers) or the accuracy of multiple symptom checkers. Use the apps argument to calculate this metric for multiple symptom checkers.
}
\description{
Calculates the accuracy on each triage level for one or multiple symptom checkers
}
\examples{
data(symptomcheckRdata)
accuracy_by_triage <- get_accuracy_by_triage(
  data = symptomcheckRdata,
  correct = "Correct_Triage_Advice_provided_from_app",
  triagelevel = "Goldstandard_solution",
  apps = "App_name"
  )
}
