/*
 * Decompiled with CFR 0.152.
 */
package haplotype;

import beagleutil.Phase;
import haplotype.BasicSampleHapPairs;
import haplotype.BitHapPair;
import haplotype.HapPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import vcf.Markers;
import vcf.VcfRecord;

public class ConsensusPhasing {
    private ConsensusPhasing() {
    }

    public static List<HapPair> consensusHaps(List<HapPair> list) {
        ArrayList<HapPair> arrayList = new ArrayList<HapPair>(list);
        if (arrayList.isEmpty()) {
            return arrayList;
        }
        ConsensusPhasing.checkMarkers(arrayList);
        Random random = new Random(arrayList.size());
        Collections.sort(arrayList, BasicSampleHapPairs.hapsComparator());
        ArrayList<HapPair> arrayList2 = new ArrayList<HapPair>(arrayList.size() / 20);
        int n = 0;
        while (n < arrayList.size()) {
            int n2;
            for (n2 = n + 1; n2 < arrayList.size() && ((HapPair)arrayList.get(n2)).idIndex() == ((HapPair)arrayList.get(n)).idIndex(); ++n2) {
            }
            if (n2 - n == 1) {
                arrayList2.add((HapPair)arrayList.get(n));
            } else {
                arrayList2.add(ConsensusPhasing.consensus(arrayList.subList(n, n2), random));
            }
            n = n2;
        }
        return arrayList2;
    }

    private static void checkMarkers(List<HapPair> list) {
        Markers markers = list.get(0).markers();
        for (int i = 1; i < list.size(); ++i) {
            if (markers.equals(list.get(i).markers())) continue;
            throw new IllegalArgumentException("inconsistent markers");
        }
    }

    private static HapPair consensus(List<HapPair> list, Random random) {
        int n = list.get(0).idIndex();
        Markers markers = list.get(0).markers();
        int n2 = markers.nMarkers();
        Phase[] phaseArray = new Phase[list.size()];
        Phase[] phaseArray2 = new Phase[list.size()];
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2];
        Phase phase = null;
        for (int i = 0; i < n2; ++i) {
            int n3 = ConsensusPhasing.consensusGT(list, markers, i, random);
            int n4 = 0;
            int n5 = n3;
            int n6 = 0;
            while (n5 > n6) {
                n5 = n3 - (n4 += ++n6);
            }
            if (n5 != n6) {
                Object object;
                assert (n5 < n6);
                ConsensusPhasing.setPhaseArray(list, i, n5, n6, phaseArray2);
                if (phase == null) {
                    phase = Phase.IDENTICAL;
                } else {
                    object = ConsensusPhasing.relPhase(phaseArray, phaseArray2, random);
                    Phase phase2 = phase = phase == object ? Phase.IDENTICAL : Phase.OPPOSITE;
                    if (phase == Phase.OPPOSITE) {
                        int n7 = n5;
                        n5 = n6;
                        n6 = n7;
                    }
                }
                object = phaseArray2;
                phaseArray2 = phaseArray;
                phaseArray = object;
            }
            byArray[i] = (byte)n5;
            byArray2[i] = (byte)n6;
        }
        return new BitHapPair(markers, n, byArray, byArray2);
    }

    private static int consensusGT(List<HapPair> list, Markers markers, int n, Random random) {
        int n2;
        int n3;
        int[] nArray = ConsensusPhasing.gtCounts(list, markers, n);
        int n4 = n3 = random.nextInt(nArray.length);
        for (n2 = n3 + 1; n2 < nArray.length; ++n2) {
            if (nArray[n2] <= nArray[n4]) continue;
            n4 = n2;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (nArray[n2] <= nArray[n4]) continue;
            n4 = n2;
        }
        return n4;
    }

    private static int[] gtCounts(List<HapPair> list, Markers markers, int n) {
        int n2 = markers.marker(n).nGenotypes();
        int[] nArray = new int[n2];
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            int n4;
            HapPair hapPair = list.get(i);
            byte by = hapPair.allele1(n);
            byte by2 = hapPair.allele2(n);
            int n5 = n4 = VcfRecord.gtIndex(by, by2);
            nArray[n5] = nArray[n5] + 1;
        }
        return nArray;
    }

    private static void setPhaseArray(List<HapPair> list, int n, int n2, int n3, Phase[] phaseArray) {
        assert (n2 < n3);
        assert (phaseArray.length == list.size());
        for (int i = 0; i < phaseArray.length; ++i) {
            byte by = list.get(i).allele1(n);
            byte by2 = list.get(i).allele2(n);
            phaseArray[i] = n2 == by && n3 == by2 ? Phase.IDENTICAL : (n2 == by2 && n3 == by ? Phase.OPPOSITE : Phase.INCONSISTENT);
        }
    }

    private static Phase relPhase(Phase[] phaseArray, Phase[] phaseArray2, Random random) {
        assert (phaseArray.length == phaseArray2.length);
        int n = 0;
        int n2 = 0;
        block8: for (int i = 0; i < phaseArray.length; ++i) {
            if (phaseArray[i] == Phase.IDENTICAL) {
                switch (phaseArray2[i]) {
                    case IDENTICAL: {
                        ++n;
                        break;
                    }
                    case OPPOSITE: {
                        ++n2;
                    }
                }
                continue;
            }
            if (phaseArray[i] != Phase.OPPOSITE) continue;
            switch (phaseArray2[i]) {
                case IDENTICAL: {
                    ++n2;
                    continue block8;
                }
                case OPPOSITE: {
                    ++n;
                }
            }
        }
        if (n > n2) {
            return Phase.IDENTICAL;
        }
        if (n2 > n) {
            return Phase.OPPOSITE;
        }
        return random.nextBoolean() ? Phase.IDENTICAL : Phase.OPPOSITE;
    }
}

