/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import java.util.BitSet;
import vcf.Marker;
import vcf.VcfEmission;
import vcf.VcfRecord;

public final class BitSetRefGT
implements VcfEmission {
    private static final String GT_FORMAT = "GT";
    private final int bitsPerAllele;
    private final Marker marker;
    private final Samples samples;
    private final BitSet allele1;
    private final BitSet allele2;

    public BitSetRefGT(VcfRecord vcfRecord) {
        if (vcfRecord.nSamples() == 0) {
            throw new IllegalArgumentException("missing sample data: " + vcfRecord);
        }
        if (!vcfRecord.hasFormat(GT_FORMAT)) {
            throw new IllegalArgumentException("missing GT FORMAT: " + vcfRecord);
        }
        BitSetRefGT.checkAlleles(vcfRecord);
        this.bitsPerAllele = BitSetRefGT.bitsPerAllele(vcfRecord.marker());
        this.marker = vcfRecord.marker();
        this.samples = vcfRecord.samples();
        this.allele1 = new BitSet(vcfRecord.nSamples() * this.bitsPerAllele);
        this.allele2 = new BitSet(vcfRecord.nSamples() * this.bitsPerAllele);
        BitSetRefGT.storeAlleles(vcfRecord, this.bitsPerAllele, this.allele1, this.allele2);
    }

    private static void checkAlleles(VcfRecord vcfRecord) {
        int n = vcfRecord.marker().nAlleles();
        int n2 = vcfRecord.nSamples();
        for (int i = 0; i < n2; ++i) {
            byte by = vcfRecord.gt(i, 0);
            byte by2 = vcfRecord.gt(i, 1);
            if (!vcfRecord.isPhased(i)) {
                String string = vcfRecord.samples().id(i);
                String string2 = "Reference genotype is not phased for sample: " + string + " marker: " + vcfRecord.marker();
                throw new IllegalArgumentException(string2);
            }
            if (by < 0 || by2 < 0) {
                String string = vcfRecord.samples().id(i);
                String string3 = "Reference genotype has a missing allele for sample: " + string + " marker: " + vcfRecord.marker();
                throw new IllegalArgumentException(string3);
            }
            if (by < n && by2 < n) continue;
            String string = vcfRecord.samples().id(i);
            String string4 = "Invalid allele index (" + Math.max(by, by2) + ") for sample: " + string + " marker: " + vcfRecord.marker();
            throw new IllegalArgumentException(string4);
        }
    }

    private static int bitsPerAllele(Marker marker) {
        int n = marker.nAlleles() - 1;
        int n2 = 32 - Integer.numberOfLeadingZeros(n);
        return n2;
    }

    private static void storeAlleles(VcfRecord vcfRecord, int n, BitSet bitSet, BitSet bitSet2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = vcfRecord.nSamples();
        for (int i = 0; i < n4; ++i) {
            int n5;
            byte by = vcfRecord.gt(i, 0);
            byte by2 = vcfRecord.gt(i, 1);
            int n6 = 1;
            for (n5 = 0; n5 < n; ++n5) {
                if ((by & n6) == n6) {
                    bitSet.set(n2);
                }
                ++n2;
                n6 <<= 1;
            }
            n6 = 1;
            for (n5 = 0; n5 < n; ++n5) {
                if ((by2 & n6) == n6) {
                    bitSet2.set(n3);
                }
                ++n3;
                n6 <<= 1;
            }
        }
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public boolean isMissingData() {
        return false;
    }

    @Override
    public boolean isRefData() {
        return true;
    }

    @Override
    public float gl(int n, byte by, byte by2) {
        boolean bl = by == this.allele1(n) && by2 == this.allele2(n);
        return bl ? 1.0f : 0.0f;
    }

    @Override
    public boolean isPhased(int n) {
        return true;
    }

    @Override
    public byte allele1(int n) {
        return this.allele(this.allele1, n);
    }

    @Override
    public byte allele2(int n) {
        return this.allele(this.allele2, n);
    }

    private byte allele(BitSet bitSet, int n) {
        int n2 = this.bitsPerAllele * n;
        int n3 = n2 + this.bitsPerAllele;
        byte by = 0;
        byte by2 = 1;
        for (int i = n2; i < n3; ++i) {
            if (bitSet.get(i)) {
                by = (byte)(by + by2);
            }
            by2 = (byte)(by2 << 1);
        }
        return by;
    }

    @Override
    public String toString() {
        String string = ".";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.marker);
        stringBuilder.append('\t');
        stringBuilder.append(string);
        stringBuilder.append('\t');
        stringBuilder.append("PASS");
        stringBuilder.append('\t');
        stringBuilder.append(string);
        stringBuilder.append('\t');
        stringBuilder.append(GT_FORMAT);
        int n = this.samples.nSamples();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('\t');
            stringBuilder.append(this.allele1(i));
            stringBuilder.append('|');
            stringBuilder.append(this.allele2(i));
        }
        return stringBuilder.toString();
    }
}

