/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.Samples;
import blbutil.Const;
import blbutil.IntPair;
import blbutil.Utilities;
import dag.Dag;
import dag.MergeableDag;
import haplotype.BasicHapPairs;
import haplotype.BasicSampleHapPairs;
import haplotype.ConsensusPhasing;
import haplotype.HapPair;
import haplotype.HapPairs;
import haplotype.SampleHapPairs;
import haplotype.Weights;
import haplotype.WrappedHapPair;
import ibd.HaploidIbd;
import ibd.IbdSegment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import main.FixedGenotypeValues;
import main.GeneticMap;
import main.GenotypeValues;
import main.HapPairSampler;
import main.NuclearFamilies;
import main.Parameters;
import main.RunStats;
import vcf.AL;
import vcf.Data;
import vcf.GL;
import vcf.HapAL;
import vcf.ImputationGL;
import vcf.Markers;
import vcf.NoPhaseGL;

class MainHelper {
    private final Parameters par;
    private final HapPairSampler hapSampler;
    private final NuclearFamilies fam;
    private final Weights weights;
    private final RunStats runStats;

    MainHelper(Parameters parameters, GeneticMap geneticMap, NuclearFamilies nuclearFamilies, Weights weights, RunStats runStats, Random random) {
        if (runStats == null) {
            throw new NullPointerException("runStats==null");
        }
        this.par = parameters;
        this.hapSampler = new HapPairSampler(parameters, runStats);
        this.fam = nuclearFamilies;
        this.weights = weights;
        this.runStats = runStats;
    }

    SampleHapPairs sample(Data data, GenotypeValues genotypeValues) {
        if (this.par.burnin_its() > 0) {
            this.runStats.println(Const.nl + "Starting burn-in iterations");
        }
        List<HapPair> list = this.runBurnin1(data);
        if (this.par.phase_its() > 0) {
            this.runStats.println(Const.nl + "Starting phasing iterations");
        }
        list = this.runBurnin2(data, list, genotypeValues);
        return MainHelper.merge(data.nonRefSamples(), list);
    }

    private List<HapPair> runBurnin1(Data data) {
        this.checkPrephasedTarget(data.nonRefEmissions().isRefData());
        int n = 0;
        int n2 = this.par.burnin_its();
        boolean bl = n % 2 == 0;
        List<HapPair> list = data.restrictedRefHaps();
        GL gL = data.nonRefEmissions();
        List<HapPair> list2 = this.hapSampler.initialHaps(this.fam, gL, gL);
        for (int i = n; i < n2; ++i) {
            bl = !bl;
            list2.addAll(list);
            list2 = this.hapSampler.sample(bl, gL, list2, this.fam, this.weights);
            this.runStats.printIterationUpdate(data.window(), i + 1);
        }
        return list2;
    }

    private List<HapPair> runBurnin2(Data data, List<HapPair> list, GenotypeValues genotypeValues) {
        if (this.par.phase_its() == 0) {
            return list;
        }
        int n = this.par.burnin_its();
        int n2 = n + this.par.phase_its();
        boolean bl = n % 2 == 0;
        ArrayList<HapPair> arrayList = new ArrayList<HapPair>(this.par.nsamples() * this.par.phase_its());
        List<HapPair> list2 = data.restrictedRefHaps();
        GL gL = data.nonRefEmissions();
        for (int i = n; i < n2; ++i) {
            bl = !bl;
            list.addAll(list2);
            list = genotypeValues == null ? this.hapSampler.sample(bl, gL, list, this.fam, this.weights) : this.hapSampler.sample(bl, gL, list, genotypeValues, this.fam, this.weights);
            arrayList.addAll(list);
            this.runStats.printIterationUpdate(data.window(), i + 1);
        }
        return arrayList;
    }

    Map<IntPair, List<IbdSegment>> refinedIbd(List<HapPair> list, GL gL, SampleHapPairs sampleHapPairs, Weights weights) {
        if (this.par.ibd()) {
            long l = System.nanoTime();
            int n = list.size() + sampleHapPairs.nSamples();
            float f = this.par.adjustedIbdScale(n);
            float[] fArray = weights.get(sampleHapPairs);
            Dag dag = this.ibdDag(list, sampleHapPairs, fArray, f, this.par.buildwindow());
            HaploidIbd haploidIbd = new HaploidIbd(this.par.ibdtrim(), this.par.ibdlod());
            NoPhaseGL noPhaseGL = new NoPhaseGL(gL);
            Map<IntPair, List<IbdSegment>> map = haploidIbd.run(noPhaseGL, dag, sampleHapPairs, this.par.nthreads());
            long l2 = (System.nanoTime() - l) / 1000000L;
            this.runStats.ibdMillis(l2);
            this.runStats.printRefinedIbdUpdate(f, dag, l2);
            return map;
        }
        return null;
    }

    private Dag ibdDag(List<HapPair> list, SampleHapPairs sampleHapPairs, float[] fArray, float f, int n) {
        float[] fArray2;
        HapPairs hapPairs;
        if (list.isEmpty()) {
            hapPairs = sampleHapPairs;
            fArray2 = fArray;
        } else {
            int n2;
            ArrayList<HapPair> arrayList = new ArrayList<HapPair>(list);
            int n3 = sampleHapPairs.nSamples();
            for (n2 = 0; n2 < n3; ++n2) {
                arrayList.add(new WrappedHapPair(sampleHapPairs, n2));
            }
            hapPairs = new BasicHapPairs(arrayList);
            n2 = 2 * list.size();
            fArray2 = new float[hapPairs.nHaps()];
            Arrays.fill(fArray2, 0, n2, 1.0f);
            System.arraycopy(fArray, 0, fArray2, n2, fArray.length);
        }
        long l = System.currentTimeMillis();
        Dag dag = MergeableDag.dag(hapPairs, fArray2, n, f);
        this.runStats.buildMillis(System.currentTimeMillis() - l);
        this.runStats.setSingleDagStats(dag);
        return dag;
    }

    SampleHapPairs impute(Data data, SampleHapPairs sampleHapPairs, GenotypeValues genotypeValues) {
        Markers markers = data.markers();
        GL gL = data.refEmissions();
        if (markers.nMarkers() > sampleHapPairs.nMarkers()) {
            int n = this.par.burnin_its() + this.par.phase_its();
            int n2 = n + this.par.impute_its();
            int n3 = this.par.nsamples() * this.par.impute_its();
            ArrayList<HapPair> arrayList = new ArrayList<HapPair>(n3);
            float f = Math.min(1.0f, 10.0f / (float)genotypeValues.nSamples());
            NuclearFamilies nuclearFamilies = new NuclearFamilies(genotypeValues.samples(), null);
            FixedGenotypeValues fixedGenotypeValues = new FixedGenotypeValues(genotypeValues, sampleHapPairs.markers());
            float f2 = 0.0f;
            HapAL hapAL = new HapAL(genotypeValues.markers(), sampleHapPairs, f2);
            ImputationGL imputationGL = new ImputationGL(markers, sampleHapPairs);
            List<HapPair> list = this.hapSampler.initialHaps(nuclearFamilies, gL, imputationGL);
            this.runStats.println(Const.nl + "Starting imputation iterations");
            Weights weights = new Weights(nuclearFamilies, f);
            this.runImpIts(data, list, hapAL, n, n2, weights, arrayList, fixedGenotypeValues);
            sampleHapPairs = MainHelper.merge(genotypeValues.samples(), arrayList);
        }
        return sampleHapPairs;
    }

    private List<HapPair> runImpIts(Data data, List<HapPair> list, AL aL, int n, int n2, Weights weights, List<HapPair> list2, GenotypeValues genotypeValues) {
        List<HapPair> list3 = data.refHaps();
        boolean bl = n % 2 == 0;
        for (int i = n; i < n2; ++i) {
            bl = !bl;
            list.addAll(list3);
            list = this.hapSampler.sample(bl, aL, list, genotypeValues, weights);
            if (list2 != null) {
                list2.addAll(list);
            }
            this.runStats.printIterationUpdate(data.window(), i + 1);
        }
        return list;
    }

    static SampleHapPairs merge(Samples samples, List<HapPair> list) {
        List<HapPair> list2 = ConsensusPhasing.consensusHaps(list);
        Collections.sort(list2, BasicSampleHapPairs.hapsComparator(samples));
        return new BasicSampleHapPairs(samples, list2);
    }

    private void checkPrephasedTarget(boolean bl) {
        if (this.par.burnin_its() == 0 && this.par.phase_its() == 0 && !bl) {
            String string = "ERROR: If \"burnin-its=0 phase-its=0\", all target genotypes  are required to be" + Const.nl + "       phased, to have the '|'allele separator," + " and to have no missing alleles.";
            Utilities.exit(Parameters.usage() + string);
        }
    }
}

