% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irreg.fd.R
\name{irreg.fd}
\alias{irreg.fd}
\title{Sample Irregular Functional Data}
\usage{
irreg.fd(
  mu = 0,
  X = wiener.process(),
  n = 100,
  m = 5,
  sig = NULL,
  snr = 5,
  domain = c(0, 1),
  delta = 1
)
}
\arguments{
\item{mu}{function, scalar or a vector defining the mean function; default value: \code{0}.}

\item{X}{centered stochastic process defined by a function of the form 
\code{X(tObs,n)} and returning \code{n*length(tObs)} matrix, where each row represents observations from a trajectory. Default value: \code{wiener.process()}.}

\item{n}{sample size; default value: \code{100}.}

\item{m}{a vector of sampling rate or scalar of average sampling rate or a function of the form \code{f(n)} generating \code{n} positive integers; default value: \code{5}.}

\item{sig}{standard deviation of measurement errors; if \code{NULL} then determined by \code{snr}.}

\item{snr}{signal to noise ratio to determine \code{sig}; default value: \code{5}.}

\item{domain}{the domain; default value: \code{c(0,1)}.}

\item{delta}{the proportion of the domain to be observed for each trajectory; default value: \code{1}.}
}
\value{
a list with the following members 
     \describe{
         \item{\code{t}}{list of design points sorted in increasing order for each trajectory.}
         \item{\code{y}}{list of vectors of observations for each trajectory.}
     }
 and with attributes \code{sig}, \code{snr}, \code{domain}, \code{delta} and
     \describe{
         \item{y0}{\code{n*m} matrix of observations without measurement errors.}
     }
}
\description{
Sample Irregular Functional Data
}
\details{
The number of observation for each trajectory is randomly generated by \code{rpois(m)+1}. For each trajectory, the reference time \code{Oi} is uniformly sampled from the interval \code{[domain[1]+delta*L/2,domain[2]-delta*L/2]}, where \code{L} is the length of \code{domain}, and the design points for the trajectory is uniformly sampled from the interval \code{[Oi-delta*L/2,Oi+delta*L/2]}.
}
\examples{
# Gaussian trajectories with constant mean function 1
Y <- irreg.fd(mu=1, X=gaussian.process(), n=10, m=5)

# trajectories froma a process defined via K-L representation
Y <- irreg.fd(mu=cos, X=kl.process(eigen.functions='FOURIER',distribution='LAPLACE'),n=10, m=5)

# trajectories with specified individual sampling rate
Y <- irreg.fd(mu=1, X=gaussian.process(cov=matern), n=10, m=rpois(10,3)+2)
}
\references{
\insertRef{Lin2020}{synfd}
}
