% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synoptclas.R
\name{synoptclas}
\alias{synoptclas}
\title{PCA Synoptic classification}
\usage{
synoptclas(x, ncomp, norm = T, matrix_mode = "S-mode", extreme_scores = 2)
}
\arguments{
\item{x}{data.frame. A data.frame with the following variables: \code{lon, lat, time, value, anom_value}. See \code{tidy_nc}.}

\item{ncomp}{Integer. Number of components to be retained.}

\item{norm}{logical. Default \code{TRUE}. \code{norm = TRUE} is recommended for classify two ore more variables.}

\item{matrix_mode}{character. The mode of matrix to use. Choose between S-mode and T-mode}

\item{extreme_scores}{Integer. Definition of extreme score threshold (Esteban et al., 2005). Default is 2. Only applicable for a \code{matrix_mode = "S-mode"}}
}
\value{
A list with: \itemize{
   \item{A data.frame containing the dates and the weather types. If "T-mode" is selected, two classifications are returned (absolute and positive/negative classification).}
   \item{A data frame containing the gridded data grouped by circulation types.If "T-mode" is selected, 3 classifications are returned (absolute correlation,maximum positive correlation, and positive/negative classification) .}
}
}
\description{
\code{synoptclas} allows to perform several types of synoptic classification approaches based on one or several atmospheric variables (i.e. mean sea level pressure, geoptential height at 500 hPa, etc.)
}
\details{
The \code{matrix_mode} argument allows to conduct different types of synoptic classifications depending on the user's objective.
If the user wants to perform a synoptic classification of a long and continuous series, he must set the \code{matrix_mode = "S-mode"}.
When we apply the PCA to a matrix in S-mode, the variables are the grid points (lon,lat) and the observations are the days (time series),
so the linear relationships that the PCA establishes are between the time series of the grid points. One of the results we obtain from the PCA are the "scores",
which indicate the degree of representativeness of each day for each of the principal components. However, the scores do not allow us to directly obtain the
weather types (WT) classification, since one day can be represented by several principal components. For this reason, a clustering method is required  to group each day
to an specific WT based on the multivariate coordinates provided by the "scores". Before using a clustering method, a VARIMAX rotation is performed on the principal Components
retained, with the aim of redistributing the variance of such components.
With the rotated components, the scores are used to apply the extreme scores method (Esteban et al., 2005). The scores show the degree of representativeness associated
with the variation modes of each principal component, i.e., the classification of each day to its more representative centroid. Thus, the extreme scores method uses
the scores > 2 and < -2, establishing a positive and negative phase for each principal component. The extreme scores procedure establishes the number of groups and their
centroids in order to apply the K-means method without iterations.
Conversely, if the user wants to perform a synoptic classification of specific events (i.e. flood events, extreme temperatures events,etc.), he must set the \code{matrix_mode = "T-mode"}.
In this case, the variables are the days (time series) and the observations are the grid points. The relationships established in this case are between each daily gridded map.
For this reason, the eigenvalues (correlations) allow to allow us to associate each day to a WT without using a clustering method as in the case of the S-mode matrix.
}
\examples{
# Load data (mslp or precp_grid)
data(mslp)
data(z500)
# Tidying our atmospheric variables (500 hPa geopotential height
# and mean sea level pressure) together.

# Time subset between two dates
atm_data1 <- tidy_nc(x = list(mslp,z500),
             name_vars = c("mslp","z500"))

# S-mode classification
smode_clas <- synoptclas(atm_data1, ncomp = 6)

# Time subset using a vector of dates of interest
dates_int <- c("2000-01-25","2000-04-01","2000-07-14","2001-05-08","2002-12-20")
atm_data2 <- tidy_nc(x = list(mslp,z500),
                     time_subset = dates_int,
                     name_vars = c("mslp","z500"))

# S-mode classification
tmode_clas <- synoptclas(atm_data2, ncomp = 2, matrix_mode = "T-mode")


}
\references{
{
Esteban, P. , Jones, P. D., Martin.Vide, J.
\emph{Atmospheric circulation patterns related to heavy snowfall days in Andorra, Pyrenees}
Int. J. Climatol. 25: 319-329. doi:10.1002/joc.1103
}
}
\seealso{
\code{\link{pca_decision}}
}
