% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_anneal_wrappers.R
\name{all_geog_synthetic_new_attribute}
\alias{all_geog_synthetic_new_attribute}
\title{Add a new attribute to a set (ie list) of synthetic_micro datasets}
\usage{
all_geog_synthetic_new_attribute(df_list, prob_name = "p",
  attr_name = "variable", attr_vector_list, attr_levels,
  conditional_vars = NULL, ht_list = NULL)
}
\arguments{
\item{df_list}{A \code{list} of R objects each of class "synthetic_micro".}

\item{prob_name}{A string specifying the column name of each \code{data.frame} in \code{df_list} 
containing the probabilities for each synthetic observation.}

\item{attr_name}{A string specifying the desired name of the new attribute to be added to the data.}

\item{attr_vector_list}{A \code{list} of named vectors with each specifying the counts or 
percentages of the new attribute, or variable, to be added. Names must include appropriate 
naming for expression matching.}

\item{attr_levels}{A character vector specifying the complete set of levels for the new 
attribute.}

\item{conditional_vars}{An character vector specifying the existing variables, if any, on which 
the new attribute (variable) is to be conditioned on for each dataset. Variables must be specified 
in order. Defaults to \code{NULL} ie- an unconditional new attribute.}

\item{ht_list}{A \code{list} of equal length to \code{conditional_vars}. Each element \code{k} of
\code{ht_list} is a \code{data.frame} constructed as a hash-table with one-to-one correspondence  
between \code{ht_list[[k]]} and \code{conditional_vars[k]}. Of the key-value pair, the key is
the first column and the value is the second column. See \code{\link{synthetic_new_attribute}}.}
}
\value{
A list of new synthetic_micro datasets each with class "synthetic_micro".
}
\description{
Add a new attribute to a set (ie list) of synthetic_micro datasets using conditional 
relationships between the new attribute and existing attributes (eg. wage rate conditioned on age 
and education level). The same attribute is added to *each* synthetic_micro dataset, where each
dataset is supplied a distinct relationship for attribute creation.
}
\seealso{
\code{\link{synthetic_new_attribute}}
}

