% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen.R
\name{data.gen.unif}
\alias{data.gen.unif}
\title{Generate correlated uniform variates}
\usage{
data.gen.unif(n, ndim = 9, r = 0.6, sigma, method = c("pearson", "spearman"))
}
\arguments{
\item{n}{The data length to be generated.}

\item{ndim}{The number of potential predictors (default is 9).}

\item{r}{The target correlation, default is 0.6.}

\item{sigma}{A symmetric matrix of Pearson correlation, should be same as ndim.}

\item{method}{The target correlation type, inluding Pearson and Spearman correlation.}
}
\value{
A matrix of correlated uniform variates
}
\description{
Generate correlated uniform variates
}
\references{
Schumann, E. (2009). Generating correlated uniform variates. COMISEF. http://comisef. wikidot. com/tutorial: correlateduniformvariates.
}
