% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExponentialFitnessLinkFun.R
\name{Model.additivelink.exponential.fitness}
\alias{Model.additivelink.exponential.fitness}
\title{Fitness model for liabilities matrix}
\usage{
Model.additivelink.exponential.fitness(n, alpha, beta, gamma = 1, lambdaprior,
  sdpropfitness = 1/sqrt(n))
}
\arguments{
\item{n}{Number of nodes in the model.}

\item{alpha}{Exponent of the power law of the degree distribution. Must be <0.}

\item{beta}{Lower endpoint of the relative expected out degree
(expected out degree divided by n-1). Must be >=0.}

\item{gamma}{Upper endpoint of the relative expected out degree
(expected out degree divided by n-1). Must be at least beta and at most 1.}

\item{lambdaprior}{Prior on zeta and eta. For the type of object
required see \code{\link{Model.fitness.genlambdaparprior}}.}

\item{sdpropfitness}{Standard deviation for the log-normally
distributed multiplicative proposals for Metropoli-Hastings updates
of the fitness. Defaults to \code{1/sqrt{n}}.}
}
\value{
A model to be used by sample_HierarchicalModel. This is a
list of functions. It includes a function accrates() that repors acceptance rates for the Metropolis-Hasting steps involved.
}
\description{
Assumes a diagonal consisting of 0s.
}
\examples{
mod <- Model.additivelink.exponential.fitness(10,alpha=-2.5,beta=0.1,
                lambdaprior=Model.fitness.genlambdaparprior(ratescale=1e3))
theta <- mod$rtheta()
L <- genL(mod)
l <- rowSums(L$L)
a <- colSums(L$L)
## increase number of samples and thinning in real examples
res <- sample_HierarchicalModel(l=l,a=a,model=mod,nsamples=4,thin=50)
mod$accrates()
}

