% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.tLagInterim.R
\name{print}
\alias{print}
\alias{print.tLagInterimObj}
\title{Print results from a tLagInterim object}
\usage{
\method{print}{tLagInterimObj}(x, ...)
}
\arguments{
\item{x}{A tLagInterimObj object, returned by tLagInterim().}

\item{...}{Ignored.}
}
\value{
No return value, called to display key results.
}
\description{
Print results from a tLagInterim object
}
\examples{
data(tLagIntCat)
# f basis functions#'
f <- function(x.data) {
       return( as.matrix(x = cbind(1.0, x.data)) )
     }

# h basis functions#'
h <- function(b.data, x.data, t.data, times) {

  # Number of basis functions L 
  # (note that the number of basis functions does not and cannot depend
  #  on the treatment group; `h` is called internally multiple times -- each
  #  call is for a single treatment group.)
  L <- 2
  
  # Number of subjects in data
  n_subjects <- nrow(x = b.data)
  
  # Number of time points
  n_times <- length(x = times)
   
  # Initialize array of basis functions for this trt
  h.basis <- array(data = 0.0, dim = c(n_subjects, n_times, L))
       
  # Indicator of still being in hospital at any censoring time
  lindicator <- outer(X = t.data$lu, Y = times, "<=") * {t.data$ldelta == 2L}
  h.basis[, , 1L] <- lindicator
     
  # Time from leaving hospital to obstime for those known to
  # leave hospital at each censoring time
  h.basis[, , 2L] <- {times - t.data$lu} * lindicator
          
  return( h.basis )
}

# fit with only baseline covariates provided, categorical outcome, user-specified f, h
res <- tLagInterim(b.data = b.data.cat,
                   x.data = x.data.cat,
                   t.data = NULL,
                   outcome = "categorical",
                   f = f, 
                   h = h)
print(res)

}
