% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractIsotopeData.R
\name{extractIsotopeData}
\alias{extractIsotopeData}
\title{Extract stable isotope data from a data frame}
\usage{
extractIsotopeData(df = NULL, b1 = "Baseline 1", b2 = NULL,
  baselineColumn = "FG", consumersColumn = "Spp",
  groupsColumn = NULL, deltaC = NULL, deltaN = NULL, d13C = "d13C",
  d15N = "d15N", seed = 3, ...)
}
\arguments{
\item{df}{data frame containing raw isotope data, with one or more grouping
variables.}

\item{b1}{string or vector with the text for baseline 1.}

\item{b2}{string or vector with the text for baseline 2.}

\item{baselineColumn}{string of the column where baselines are grouped.}

\item{consumersColumn}{string of the column where consumers/species are
grouped.}

\item{groupsColumn}{string of the column where groups/communities are
grouped.}

\item{deltaC}{vector of values with trophic discrimination factor for carbon.
If NULL it will use Post's assumptions (56 values with 3.4 mean +- 0.98
sd).}

\item{deltaN}{vector of values with trophic discrimination factor for
nitrogen. If NULL it will use Post's assumptions (107 values with 0.39 mean
+- 1.3 sd).}

\item{d13C}{string of the column that has d13C isotope values.}

\item{d15N}{string of the column that has d15N isotope values.}

\item{seed}{integer to get reproducible results. By default, seed = 3.}

\item{...}{Additional arguments passed to this funcion.}
}
\value{
a list with isotopeData class objects
}
\description{
This function generates a list of isotopeData class objects parsing a data
frame of stable isotope values analysed for one or more consumers and one or
two baselines. The data frame can be organized in one or more communities (or
sampling sites, samples in time, multiple studies, etc.).
}
\examples{
data("Bilagay")
head(Bilagay)
isotopeList <- extractIsotopeData(Bilagay, b1 = "Benthic_BL",
b2 = "Pelagic_BL", baselineColumn = "FG", consumersColumn = "Spp",
groupsColumn = "Location", d13C = "d13C", d15N = "d15N")
}
