% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_tableHTML_family.R
\name{tableHTML_output}
\alias{tableHTML_output}
\title{Implementing tableHTML in shiny}
\usage{
tableHTML_output(outputId, inline = FALSE, container = if (inline) span else
  div, ...)
}
\arguments{
\item{outputId}{input name.}

\item{inline}{use an inline (span()) or block container (div()) for the output.}

\item{container}{a function to generate an HTML element to contain the text.}

\item{...}{Other arguments to pass to the container tag function. This is useful for providing 
additional classes for the tag.}
}
\description{
This function is used to implement tableHTML in a shiny app. It is used in the shiny
ui.R file. Internally, it just calls uiOutput, since tableHTML creates HTML code.
}
\examples{
\dontrun{

library(shiny)
shinyApp(
 ui = fluidPage(
  fluidRow(
  #leave some spacing
  br(),
  column(width = 1),
  tableHTML_output("mytable"))
 ), 
server = function(input, output) {
 output$mytable <- render_tableHTML( 
  tableHTML(mtcars)
 )}
)

}

}
\seealso{
\code{uiOutput}
}

