% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableMatrix.R
\name{rbind.tableMatrix}
\alias{rbind.tableMatrix}
\title{Combine by rows}
\usage{
rbind.tableMatrix(..., use.names = TRUE, fill = FALSE)
}
\arguments{
\item{...}{\code{tableMatrix} objects.}

\item{use.names}{Passed to rbind.data.table.}

\item{fill}{Passed to rbind.data.table.}
}
\value{
\code{tableMatrix} object.
}
\description{
\code{tableMatrix} method, binds rows of \code{tableMatrix} objects. If 
matrix parts have the same dimensions, it combines rows in table and matrix parts
using data.table and matrix rbind methods respectively. In case when dimensions differ
it combines rows in table part and adds new matrix to the matrix part.
}
\examples{

data(images8By8)
dim(images8By8)

data(images10By10)
dim(images10By10) 

# Create tableMatrix objects from images8By8 and images10By10
TM1 <- tableMatrix(images8By8, 1:3, 4:ncol(images8By8))
TM2 <- tableMatrix(images10By10, 1:3, 4:ncol(images10By10))

# Combining tableMatrix objects with same dimensions
TM <- rbind(TM1, TM1)
# Combined table part
tab(TM)
# One matrix in the matrix part
length(mat(TM))
# One dimension type
matDim(TM)

# Combining tableMatrix objects with different dimensions
TM <- rbind(TM1, TM2)
# Combined table part
tab(TM)
# Two matrices in the matrix part
length(mat(TM))
# Two dimension types
matDim(TM)

}

