% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div_custom.R
\name{div_custom}
\alias{div_custom}
\title{Split a Variable by Custom Values}
\usage{
div_custom(var, div, data)
}
\arguments{
\item{var}{A string. A variable to be summarized given as a string.}

\item{div}{A numeric vector. The variable can be split into at least two levels by custom values.}

\item{data}{A data frame in which these variables exist.}
}
\value{
A factor variable.
}
\description{
Split a continuous variable by custom values. Converts a continuous variable to a categorical variable.
}
\examples{
## Load Mayo Clinic Primary Biliary Cirrhosis Data
library(survival)
library(tableeasy)
data(pbc)
## Check variables
head(pbc)
##
div_custom(var = 'age',div = c(40,60),data = pbc)
}
