% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{tablerTag}
\alias{tablerTag}
\title{Create a Boostrap 4 tag}
\usage{
tablerTag(name, href = NULL, rounded = FALSE, color = NULL,
  addon = NULL, addonColor = NULL)
}
\arguments{
\item{name}{Tag name.}

\item{href}{Tag external link.}

\item{rounded}{Whether the tag is rounded. FALSE by default.}

\item{color}{Tag color. See \url{https://preview.tabler.io/docs/colors.html}.}

\item{addon}{Tag addon (right side).}

\item{addonColor}{Addon background color. See \url{https://preview.tabler.io/docs/colors.html}.}
}
\description{
Build a tabler tag
}
\examples{
if(interactive()){
 library(shiny)
 library(tablerDash)

 shiny::shinyApp(
   ui = tablerDashPage(
    navbar = NULL,
    footer = NULL,
    title = "test",
    body = tablerDashBody(
     tablerTag(name = "Tag"),
     tablerTag(name = "Tag", href = "https://www.google.com"),
     tablerTag(name = "Tag", rounded = TRUE, color = "pink"),
     tablerTag(
      name = "npm",
      href = "https://www.google.com",
      color = "dark",
      addon = "passing",
      addonColor = "warning"
     ),
     tablerTag(name = "build", addon = "passing", addonColor = "success")
    )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
