% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.castDate.R
\name{types.castDate}
\alias{types.castDate}
\title{Cast date}
\usage{
types.castDate(format = "default", value)
}
\arguments{
\item{format}{available options are "default", "any", and "<pattern>" where
\describe{
\item{\code{default }}{An ISO8601 format string
\itemize{
\item{\code{date:}}{ This \code{MUST} be in ISO8601 format YYYY-MM-DD}
\item{\code{datetime:}}{ a date-time. This \code{MUST} be in ISO 8601 format of YYYY-MM-DDThh:mm:ssZ in UTC time}
\item{\code{time:}}{ a time without a date}
}}
\item{\code{any }}{Any parsable representation of the type. The implementing library 
can attempt to parse the datetime via a range of strategies, e.g. \href{https://CRAN.R-project.org/package=lubridate}{lubridate}, 
\href{https://CRAN.R-project.org/package=parsedate}{parsedate},\code{\link[base]{strptime}},
\code{\link[base]{DateTimeClasses}}.}
\item{\code{<pattern> }}{date/time values in this field can be parsed according to \code{pattern}.
 \code{<pattern>} MUST follow the syntax of \code{\link[base]{strptime}}. 
 (That is, values in the this field should be parseable by R using \code{<pattern>}).}
}}

\item{value}{date to cast}
}
\description{
cast date without a time
}
\examples{
types.castDate(format = "default", value =  as.Date("2019-1-1"))

types.castDate(format = "default", value = "2019-1-1")

types.castDate(format = "any", value = "2019-1-1")

types.castDate(format = "\%d/\%m/\%y", value = "21/11/06")

types.castDate(format = "\%d/\%m/\%y", value = as.Date("2019-1-1"))

}
\seealso{
\href{https://frictionlessdata.io/specs/table-schema/#date}{Types and formats specifications}, 
\code{\link[base]{strptime}}, \code{\link[base]{DateTimeClasses}},
\code{\link[parsedate]{parsedate-package}} and 
\code{\link[lubridate]{lubridate-package}}.
}
