% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chords.R
\name{chord-compare}
\alias{chord-compare}
\alias{chord_rank}
\alias{chord_order}
\alias{chord_sort}
\title{Rank, order and sort chords and notes}
\usage{
chord_rank(chords, pitch = c("min", "mean", "max"), ...)

chord_order(chords, pitch = c("min", "mean", "max"), ...)

chord_sort(chords, pitch = c("min", "mean", "max"), decreasing = FALSE,
  ...)
}
\arguments{
\item{chords}{character, a noteworthy string, may include individual notes and chords.}

\item{pitch}{character, how ranking of chords is determined; lowest pitch, mean pitch, or highest pitch.}

\item{...}{additional arguments passed to \code{rank} or \code{order}.}

\item{decreasing}{logical, sort in decreasing order.}
}
\value{
integer for rank and order, character for sort
}
\description{
Rank, order and sort chords and notes by various definitions.
}
\details{
There are three options for comparing the relative pitch position of chords provided: comparison of the lowest or root note of each chord, the highest pitch note, or taking the mean of all notes in a chord.
}
\examples{
x <- "a2 c a2 ceg ce_g cea"
chord_rank(x, "min")
chord_rank(x, "max")
chord_rank(x, "mean")

chord_order(x)
chord_order(x, "mean")
chord_sort(x, "mean")
}
