% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracks.R
\name{score}
\alias{score}
\title{Create a music score}
\usage{
score(track, chords = NULL, chord_seq = NULL)
}
\arguments{
\item{track}{a track table consisting of one or more tracks.}

\item{chords}{an optional named list of chords and respective fingerings
generated by \code{chord_set}, for inclusion of a top center chord diagram
chart.}

\item{chord_seq}{an optional named vector of chords and their durations, for
placing chord diagrams above staves in time.}
}
\value{
a tibble data frame
}
\description{
Create a music score from a collection of tracks.
}
\details{
Score takes track tables generated by \code{\link{track}} and fortifies them
as a music score. It optionally binds tracks with a set of chord diagrams.
There may be only one track in \code{track} as well as no chord information
passed, but for consistency \code{score} is still required to fortify the
single track as a score object that can be rendered by \code{\link{tab}}.
}
\examples{
x <- phrase("c ec'g' ec'g'", "4 4 2", "5 432 432")
x <- track(x)
score(x)
}
\seealso{
\code{\link{phrase}}, \code{\link{track}}, \code{\link{trackbind}}
}
