% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{OccurrenceMatrix-class}
\alias{OccurrenceMatrix-class}
\title{Co-occurrence matrix}
\description{
An S4 class to represent a co-occurrence matrix.
}
\details{
A co-occurrence matrix is a symetric matrix with zeros on its main diagonal,
 which works out which pairs of taxa occur together in at least one sample
}
\note{
This class extends the \code{base} \link[base]{matrix}.
}
\examples{
# Create an incidence (presence/absence) matrix
# Data will be coerced with as.logical()
C1 <- IncidenceMatrix(data = sample(0:1, 100, TRUE),
                      nrow = 10, ncol = 10)

# Coerce to a co-occurrence matrix
D <- as(C1, "OccurrenceMatrix")

# Create a count data matrix
A <- CountMatrix(data = sample(0:10, 100, TRUE),
                 nrow = 10, ncol = 10, byrow = TRUE)

# Coerce to presence/absence
C2 <- as(A, "IncidenceMatrix")
}
\seealso{
\link[base]{matrix}

Other logical matrix: \code{\link{IncidenceMatrix-class}}
}
\author{
N. Frerebeau
}
\concept{logical matrix}
