% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/index-diversity.R
\docType{methods}
\name{diversity}
\alias{diversity}
\alias{diversity-method}
\alias{evenness}
\alias{evenness-method}
\alias{diversity,CountMatrix-method}
\alias{evenness,CountMatrix-method}
\title{Heterogeneity and Evenness}
\usage{
diversity(object, ...)

evenness(object, ...)

\S4method{diversity}{CountMatrix}(object, method = c("berger",
  "brillouin", "mcintosh", "shannon", "simpson"), simplify = FALSE, ...)

\S4method{evenness}{CountMatrix}(object, method = c("brillouin",
  "mcintosh", "shannon", "simpson"), simplify = FALSE, ...)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} matrix of count data.}

\item{...}{Further arguments to be passed to internal methods.}

\item{method}{A \code{\link{character}} string or vector of strings
specifying the index to be computed (see details).
Any unambiguous substring can be given.}

\item{simplify}{A \code{\link{logical}} scalar: should the result be
simplified to a matrix? The default value, \code{FALSE}, returns a list.}
}
\value{
If \code{simplify} is \code{FALSE}, then \code{diversity} and
 \code{evenness} return a list (default), else return a matrix.
}
\description{
\code{diversity} returns a diversity or dominance index.
 \code{evenness} returns an evenness measure.
}
\details{
\emph{Diversity} measurement assumes that all individuals in a specific
 taxa are equivalent and that all types are equally different from each
 other (Peet 1974). A measure of diversity can be achieved by using indices
 built on the relative abundance of taxa. These indices (sometimes referred
 to as non-parametric indices) benefit from not making assumptions about the
 underlying distribution of taxa abundance: they only take relative
 abundances of the species that are present and species richness into
 account. Peet (1974) refers to them as indices of \emph{heterogeneity}.

 Diversity indices focus on one aspect of the taxa abundance and emphasize
 either \emph{richness} (weighting towards uncommon taxa)
 or dominance (weighting towards abundant taxa; Magurran 1988).

 \emph{Evenness} is a measure of how evenly individuals are distributed
 across the sample.

 The following heterogeneity index and corresponding evenness measures
 are available (see Magurran 1988 for details):
 \describe{
  \item{berger}{Berger-Parker dominance index. The Berger-Parker index
   expresses the proportional importance of the most abundant type. This
   metric is highly biased by sample size and richness, moreover it does not
   make use of all the information available from sample.}
  \item{brillouin}{Brillouin diversity index. The Brillouin index describes a
   known collection: it does not assume random sampling in an infinite
   population. Pielou (1975) and Laxton (1978) argues for the use of the
   Brillouin index in all circumstances, especially in preference to the
   Shannon index.}
  \item{mcintosh}{McIntosh dominance index. The McIntosh index expresses the
   heterogeneity of a sample in geometric terms. It describes the sample as a
   point of a \code{S}-dimensional hypervolume and uses the Euclidean
   distance of this point from the origin.}
  \item{shannon}{Shannon-Wiener diversity index. The Shannon index assumes
   that individuals are randomly sampled from an infinite population and that
   all taxa are represented in the sample (it does not reflect the
   sample size). The main source of error arises from the failure to include
   all taxa in the sample: this error increases as the proportion of species
   discovered in the sample declines (Peet 1974, Magurran 1988). The
   maximum likelihood estimator (MLE) is used for the relative abundance,
   this is known to be negatively biased by sample size.}
  \item{simpson}{Simpson dominance index for finite sample. The Simpson index
   expresses the probability that two individuals randomly picked from a
   finite sample belong to two different types. It can be interpreted as the
   weighted mean of the proportional abundances. This metric is a true
   probability value, it ranges from \code{0} (perfectly uneven) to \code{1}
   (perfectly even).}
 }

 The \code{berger}, \code{mcintosh} and \code{simpson} methods return a
 \emph{dominance} index, not the reciprocal or inverse form usually adopted,
 so that an increase in the value of the index accompanies a decrease in
 diversity.
}
\note{
Ramanujan approximation is used for \eqn{x!} computation if \eqn{x > 170}.
}
\examples{
# Shannon diversity index
# Data from Magurran 1988, p. 145-149
birds <- CountMatrix(
  data = c(35, 26, 25, 21, 16, 11, 6, 5, 3, 3,
           3, 3, 3, 2, 2, 2, 1, 1, 1, 1, 0, 0,
           30, 30, 3, 65, 20, 11, 0, 4, 2, 14,
           0, 3, 9, 0, 0, 5, 0, 0, 0, 0, 1, 1),
  nrow = 2, byrow = TRUE, dimnames = list(c("oakwood", "spruce"), NULL))

diversity(birds, "shannon") # 2.40 2.06
evenness(birds, "shannon") # 0.80 0.78

# Brillouin diversity index
# Data from Magurran 1988, p. 150-151
moths <- CountMatrix(data = c(17, 15, 11, 4, 4, 3, 3, 3, 2, 2, 1, 1, 1),
                     nrow = 1, byrow = TRUE)

diversity(moths, "brillouin") # 1.88
evenness(moths, "brillouin") # 0.83

# Simpson dominance index
# Data from Magurran 1988, p. 152-153
trees <- CountMatrix(
  data = c(752, 276, 194, 126, 121, 97, 95, 83, 72, 44, 39,
           16, 15, 13, 9, 9, 9, 8, 7, 4, 2, 2, 1, 1, 1),
  nrow = 1, byrow = TRUE
)

diversity(trees, "simpson") # 1.19
evenness(trees, "simpson") # 0.21

# McIntosh dominance index
# Data from Magurran 1988, p. 154-155
invertebrates <- CountMatrix(
  data = c(254, 153, 90, 69, 68, 58, 51, 45, 40, 39, 25, 23, 19, 18, 16, 14, 14,
           11, 11, 11, 11, 10, 6, 6, 6, 6, 5, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1),
  nrow = 1, byrow = TRUE
)

diversity(invertebrates, "mcintosh") # 0.71
evenness(invertebrates, "mcintosh") # 0.82

# Berger-Parker dominance index
# Data from Magurran 1988, p. 156-157
fishes <- CountMatrix(
  data = c(394, 3487, 275, 683, 22, 1, 0, 1, 6, 8, 1, 1, 2,
           1642, 5681, 196, 1348, 12, 0, 1, 48, 21, 1, 5, 7, 3,
           90, 320, 180, 46, 2, 0, 0, 1, 0, 0, 2, 1, 5,
           126, 17, 115, 436, 27, 0, 0, 3, 1, 0, 0, 1, 0,
           32, 0, 0, 5, 0, 0, 0, 0, 13, 9, 0, 0, 4),
  nrow = 5, byrow = TRUE,
  dimnames = list(c("station 1", "station 2", "station 3",
                    "station 4", "station 5"), NULL)
)

diversity(fishes, "berger") # 0.71 0.63 0.50 0.60 0.51
}
\references{
Berger, W. H. & Parker, F. L. (1970). Diversity of Planktonic Foraminifera
 in Deep-Sea Sediments. \emph{Science}, 168(3937), 1345-1347.
 DOI: \href{https://doi.org/10.1126/science.168.3937.1345}{10.1126/science.168.3937.1345}.

 Brillouin, L. (1956). \emph{Science and information theory}. New York:
 Academic Press.

 Laxton, R. R. (1978). The measure of diversity. \emph{Journal of Theoretical
 Biology}, 70(1), 51-67.
 DOI: \href{https://doi.org/10.1016/0022-5193(78)90302-8}{10.1016/0022-5193(78)90302-8}.

 Magurran, A. E. (1988). \emph{Ecological Diversity and its Measurement}.
 Princeton, NJ: Princeton University Press.
 DOI: \href{https://doi.org/10.1007/978-94-015-7358-0}{10.1007/978-94-015-7358-0}.

 McIntosh, R. P. (1967). An Index of Diversity and the Relation of Certain
 Concepts to Diversity. \emph{Ecology}, 48(3), 392-404.
 DOI: \href{https://doi.org/10.2307/1932674}{10.2307/1932674}.

 Peet, R. K. (1974). The Measurement of Species Diversity. \emph{Annual
 Review of Ecology and Systematics}, 5(1), 285-307.
 DOI: \href{https://doi.org/10.1146/annurev.es.05.110174.001441}{10.1146/annurev.es.05.110174.001441}.

 Pielou, E. C. (1975). \emph{Ecological Diversity}. New York: Wiley.
 DOI: \href{https://doi.org/10.4319/lo.1977.22.1.0174b}{10.4319/lo.1977.22.1.0174b}

 Shannon, C. E. (1948). A Mathematical Theory of Communication. \emph{The
 Bell System Technical Journal}, 27, 379-423.
 DOI: \href{https://doi.org/10.1002/j.1538-7305.1948.tb01338.x}{10.1002/j.1538-7305.1948.tb01338.x}.

 Simpson, E. H. (1949). Measurement of Diversity. \emph{Nature}, 163(4148),
 688-688. DOI: \href{https://doi.org/10.1038/163688a0}{10.1038/163688a0}.
}
\seealso{
\code{\link{turnover}}
 \code{\link{similarity}}

Other diversity: \code{\link{richness}},
  \code{\link{similarity}}, \code{\link{turnover}}
}
\author{
N. Frerebeau
}
\concept{diversity}
