% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot-rank.R
\docType{methods}
\name{plot_line}
\alias{plot_line}
\alias{plot_rank}
\alias{plot_rank-method}
\alias{plot_rank,CountMatrix-method}
\alias{plot_rank,AbundanceMatrix-method}
\title{Line Plot}
\usage{
plot_rank(object, ...)

\S4method{plot_rank}{CountMatrix}(object, log = NULL, facet = TRUE)

\S4method{plot_rank}{AbundanceMatrix}(object, log = NULL, facet = TRUE)
}
\arguments{
\item{object}{An object to be plotted.}

\item{...}{Further arguments to be passed to internal methods.}

\item{log}{A \code{\link{character}} string which contains "\code{x}" if the
x axis is to be logarithmic, "\code{y}" if the y axis is to be logarithmic
and "\code{xy}" or "\code{yx}" if both axes are to be logarithmic (base 10).}

\item{facet}{A \code{\link{logical}} scalar: should a matrix of panels
defined by case/sample be drawn?}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
\code{plot_rank} plots a rank \emph{vs} relative abundance diagram.
}
\details{
TODO
}
\examples{
## Abundance matrix
## Coerce datasets to a count matrix (data from Desachy 2004)
compiegne_count <- as_count(compiegne)

## Plot rank vs abundance
plot_rank(compiegne_count)
plot_rank(compiegne_count, facet = FALSE)
}
\references{
Magurran, A. E. (1988). \emph{Ecological Diversity and its Measurement}.
 Princeton, NJ: Princeton University Press.
 DOI: \href{https://doi.org/10.1007/978-94-015-7358-0}{10.1007/978-94-015-7358-0}.
}
\seealso{
Other plot: 
\code{\link{plot_bar}},
\code{\link{plot_date}()},
\code{\link{plot_diversity}()},
\code{\link{plot_matrix}},
\code{\link{plot_spot}()}
}
\author{
N. Frerebeau
}
\concept{plot}
