% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot_diversity.R
\docType{methods}
\name{plot_diversity}
\alias{plot_diversity}
\alias{autoplot,DiversityIndex-method}
\alias{plot,DiversityIndex,missing-method}
\alias{autoplot,RarefactionIndex-method}
\alias{plot,RarefactionIndex,missing-method}
\title{Diversity Plot}
\usage{
\S4method{autoplot}{DiversityIndex}(object, ...)

\S4method{plot}{DiversityIndex,missing}(x, y, ...)

\S4method{autoplot}{RarefactionIndex}(object, ...)

\S4method{plot}{RarefactionIndex,missing}(x, y, ...)
}
\arguments{
\item{object, x}{A \linkS4class{DiversityIndex} object to be plotted.}

\item{...}{Currently not used.}

\item{y}{Currently not used.}
}
\value{
\itemize{
\item \code{autoplot()} returns a \code{\link[ggplot2:ggplot]{ggplot}} object.
\item \code{plot()} is called it for its side-effects: it results in a graphic being
displayed (invisibly returns \code{x}).
}
}
\description{
Diversity Plot
}
\examples{
\donttest{
## Coerce data to a count matrix
data("chevelon", package = "folio")

## Assemblage diversity size comparison
## Warning: this may take a few seconds!
h <- heterogeneity(chevelon, method = "shannon")
h_sim <- simulate(h)
plot(h_sim)

r <- richness(chevelon, method = "count")
r_sim <- simulate(r)
plot(r_sim)
}
}
\seealso{
Other diversity measures: 
\code{\link{heterogeneity}()},
\code{\link{occurrence}()},
\code{\link{rarefaction}()},
\code{\link{richness}()},
\code{\link{similarity}()},
\code{\link{simulate}()},
\code{\link{turnover}()}

Other plot methods: 
\code{\link{plot_bar}},
\code{\link{plot_heatmap}()},
\code{\link{plot_line}},
\code{\link{plot_spot}()}
}
\author{
N. Frerebeau
}
\concept{diversity measures}
\concept{plot methods}
