% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/index_turnover.R
\docType{methods}
\name{turnover}
\alias{turnover}
\alias{turnover-method}
\alias{index_whittaker}
\alias{index_whittaker-method}
\alias{index_cody}
\alias{index_cody-method}
\alias{index_routledge1}
\alias{index_routledge1-method}
\alias{index_routledge2}
\alias{index_routledge2-method}
\alias{index_routledge3}
\alias{index_routledge3-method}
\alias{index_wilson}
\alias{index_wilson-method}
\alias{turnover,matrix-method}
\alias{turnover,data.frame-method}
\alias{index_whittaker,matrix-method}
\alias{index_cody,matrix-method}
\alias{index_routledge1,matrix-method}
\alias{index_routledge2,matrix-method}
\alias{index_routledge3,matrix-method}
\alias{index_wilson,matrix-method}
\title{Turnover}
\usage{
turnover(object, ...)

index_whittaker(x, ...)

index_cody(x, ...)

index_routledge1(x, ...)

index_routledge2(x, ...)

index_routledge3(x, ...)

index_wilson(x, ...)

\S4method{turnover}{matrix}(
  object,
  method = c("whittaker", "cody", "routledge1", "routledge2", "routledge3", "wilson"),
  ...
)

\S4method{turnover}{data.frame}(
  object,
  method = c("whittaker", "cody", "routledge1", "routledge2", "routledge3", "wilson"),
  ...
)

\S4method{index_whittaker}{matrix}(x)

\S4method{index_cody}{matrix}(x)

\S4method{index_routledge1}{matrix}(x)

\S4method{index_routledge2}{matrix}(x)

\S4method{index_routledge3}{matrix}(x)

\S4method{index_wilson}{matrix}(x)
}
\arguments{
\item{object, x}{A \eqn{m \times p}{m x p} matrix of count data or incidence
data.}

\item{...}{Further arguments to be passed to internal methods.}

\item{method}{A \code{\link{character}} string specifying the method to be
used (see details). Any unambiguous substring can be given.}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Returns the degree of turnover in taxa composition along a gradient or
transect.
}
\details{
The following methods can be used to ascertain the degree of \emph{turnover}
in taxa composition along a gradient (\eqn{\beta}-diversity) on qualitative
(presence/absence) data. This assumes that the order of the matrix rows
(from \eqn{1} to \eqn{n}) follows the progression along the
gradient/transect.

\describe{
\item{\code{whittaker}}{Whittaker measure.}
\item{\code{cody}}{Cody measure.}
\item{\code{routledge1}}{Routledge first measure.}
\item{\code{routledge2}}{Routledge second measure.}
\item{\code{routledge3}}{Routledge third measure. This is the exponential form
of the second measure.}
\item{\code{wilson}}{Wilson measure.}
}
}
\examples{
## Data from Magurran 1988, p. 162
trees <- matrix(
  data = c(1, 1, 1, 0, 0, 0,
           1, 1, 1, 1, 1, 1,
           0, 0, 1, 0, 1, 0,
           0, 0, 0, 1, 1, 1,
           0, 0, 0, 0, 1, 1,
           0, 0, 0, 1, 0, 1),
  nrow = 6, byrow = FALSE
)
colnames(trees) <- c("Birch", "Oak", "Rowan", "Beech", "Hazel", "Holly")

## Whittaker's measure
turnover(trees, "whittaker") # 1

## Cody's measure
turnover(trees, "cody") # 3

## Routledge's measures
turnover(trees, "routledge1") # 0.29
turnover(trees, "routledge2") # 0.56
turnover(trees, "routledge3") # 1.75

## Wilson and Shmida's measure
turnover(trees, "wilson") # 1
}
\references{
Cody, M. L. (1975). Towards a theory of continental species diversity: Bird
distributions over Mediterranean habitat gradients. \emph{In} M. L. Cody &
J. M. Diamond (Eds.), \emph{Ecology and Evolution of Communities}.
Cambridge, MA: Harvard University Press, p. 214-257.

Routledge, R. D. (1977). On Whittaker's Components of Diversity.
\emph{Ecology}, 58(5), 1120-1127. \doi{10.2307/1936932}.

Whittaker, R. H. (1960). Vegetation of the Siskiyou Mountains, Oregon and
California. \emph{Ecological Monographs}, 30(3), 279-338.
\doi{10.2307/1943563}.

Wilson, M. V., & Shmida, A. (1984). Measuring Beta Diversity with
Presence-Absence Data. \emph{The Journal of Ecology}, 72(3), 1055-1064.
\doi{10.2307/2259551}.
}
\seealso{
Other diversity measures: 
\code{\link{heterogeneity}()},
\code{\link{occurrence}()},
\code{\link{plot_diversity}},
\code{\link{rarefaction}()},
\code{\link{richness}()},
\code{\link{similarity}()},
\code{\link{simulate}()}
}
\author{
N. Frerebeau
}
\concept{diversity measures}
